-------------------------------------------------------------------------------- 
-- UPC - EETAC - EEL - CSD - DIGSYS http://digsys.upc.edu      
--------------------------------------------------------------------------------
-- P8. Tutorial on synchronous frequency dividers

-- Divider by 20 with asynchronous clear direct (CD), count enable (CE) and 
-- terminal count (TC125)to allow chaining with similar blocks.
-- TC20 is active high only one CLK period every 20, a pulsed waveform

-- Plan: FSM 
-- Reference schematic: 
--------------------------------------------------------------------------------

LIBRARY IEEE;
   USE IEEE.STD_LOGIC_1164.ALL;
   USE IEEE.STD_LOGIC_ARITH.ALL;
   USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY freq_div_20 IS  
      PORT(CD,CLK,CE	: 	IN  std_logic;
           TC20			:	OUT std_logic
          );
END freq_div_20;

ARCHITECTURE FSM_like OF freq_div_20 IS

-- "Max_Count" is 19 in binary (the last state of the counter). 

CONSTANT Max_Count	: STD_LOGIC_VECTOR(4 DOWNTO 0) 	:= "10011"; -- 19
CONSTANT Reset		: STD_LOGIC_VECTOR(4 DOWNTO 0) 	:= "00000"; 

-- Internal wires 

SIGNAL present_state,future_state: STD_LOGIC_VECTOR(4 downto 0) := Reset;
-- Remember that this idea of ":= Reset;" initalising the wires, has sense only 
-- for the simulator, not for a real synthesised flatened circuit, 
-- in which CD is used to reset the flip-flops because they can be in any 
-- state when the circuit is powered. 

BEGIN
------    The only clocked block : the state register
state_register: PROCESS (CD, CLK, future_state)
	BEGIN
						
	IF CD = '1' THEN 						-- reset counter
		present_state <= Reset; 
	ELSIF (CLK'EVENT and CLK = '1') THEN	-- D-type flip-flop
		present_state <= future_state; 
	END IF;

END PROCESS state_register;

------    CC1. combinational system for calculating next state
CS_1: PROCESS (present_state, CE)
	BEGIN
	IF CE = '1' THEN
		IF(present_state < Max_Count ) THEN
			future_state <= present_state + 1 ;
		ELSE
			future_state <= Reset;
		END IF;
	ELSE 	
		future_state <= present_state;  -- count disable
	END IF;

END PROCESS CS_1;

------    CC2: Combinational circuit for calculating output logic  

TC20 <= '1' WHEN ((present_state = Max_count) AND CE = '1') ELSE '0'; 

END FSM_like;