-------------------------------------------------------------------------------- 
-- UPC - EETAC - EEL - CSD - DIGSYS https://digsys.upc.edu     
--------------------------------------------------------------------------------
-- Example of T_FF in VHDL defined as a FSM using plan C1
-- Full project at: https://digsys.upc.edu/csd/P05/T_FF/T_FF.html
-- Style FSM with state enumeration (only for FSM with a few number of states)
---------------------------------------------------
-- Project P5 One-bit synchronous memory cells 
-- P6 - FSM  
--------------------------------------------------------------------------------

LIBRARY ieee;
USE  IEEE.STD_LOGIC_1164.all;

ENTITY T_FF IS
	Port (	
     	CLK 	: IN	STD_LOGIC;
		CD 		: IN	STD_LOGIC;
		T		: IN	STD_LOGIC;
		Q 		: OUT	STD_LOGIC
	);

END T_FF;

			-- Internal description in FSM style

ARCHITECTURE FSM_like OF T_FF IS

	TYPE State_type IS (Reset_state, Set_state);  

-- Constants: another name for initial state
CONSTANT Reset	: State_type := Reset_state;    

-- Internal wires to connect the three processes in this plan C1
	SIGNAL current_state, next_state	: State_type ; 

BEGIN
--------------------------------------------------------------------------------
---------- Clocked block : the state register (D_FF)
state_register: PROCESS (CD, CLK, next_state )
	BEGIN
						
	IF CD = '1' THEN 			-- Asynchronous reset has precedence
		current_state <= Reset; 
			-- Synchronous register (D-type flip-flop)
	ELSIF (CLK'EVENT and CLK = '1') THEN
		current_state <= next_state; 
	END IF;

END PROCESS state_register;

----------- CC_1: The next state logic (where to go after a CLK's rising edge)
CC_1: PROCESS (current_state, T)
	BEGIN

		CASE current_state is

			when Reset_state =>
				if T = '1' then 
					next_state <= Set_state;
				else
					next_state <= Reset_state ;
				end if;

			when Set_state =>
				if T = '1' then 
					next_state <= Reset_state;
				else
					next_state <= Set_state ;
				end if;
		end case;

END PROCESS CC_1;

------------- CC_2: combinational system for calculating outputs 
CC_2: PROCESS (current_state)
	BEGIN
		CASE current_state is
			when Reset_state =>
				Q <= '0';
			when Set_state =>
				Q <= '1';
		end case;

END PROCESS CC_2;

END FSM_like;
