-------------------------------------------------------------------------------- 
-- UPC - EETAC - EEL - CSD - DIGSYS https://digsys.upc.edu     
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- An example of a MUX_2, multiplexer or data selector of 2 channels with enable
-- This component is used as a building block for many other projects     

-- For some EDA tools the name "MUX2" is a reserved word, and so, generates 
-- complications or errors. Therefore we use "MUX_2" instead. 
---------------------------------------------------
-- Project P2  - CSD 
-- https://digsys.upc.edu
--------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;

entity MUX_2 is
PORT(
	CH0	:IN STD_LOGIC; 
	CH1	:IN STD_LOGIC; 
	E	:IN STD_LOGIC;
	Y	:OUT STD_LOGIC;
	S	:IN STD_LOGIC 
    );
end MUX_2;

architecture truth_table of MUX_2 is
begin
-- This is a behavioural interpretation of the truth table
Y	<=	CH0  WHEN S ='0' AND E = '1' ELSE
		CH1  WHEN S ='1' AND E = '1' 
		ELSE '0'; -- disable
end truth_table;

