-------------------------------------------------------------------------------- 
-- UPC - EETAC - EEL - CSD - DIGSYS       
--------------------------------------------------------------------------------
-- CLK_Generator circuit to obtain synchronous squared signals
-- Plan C2: schematic using frequency dividers and TFF to square signals
---------------------------------------------------
-- Project P8, Lecture L8.2
-- https://digsys.upc.edu/csd/P08/L08_2/L8_2.html
--------------------------------------------------------------------------------
-- OSC_CLK_in => 50 MHz  (DE0 board quartz oscillator)
-- CLK_A_SQ => 20Hz, fast shifting
-- CLK_B_SQ => 1Hz, slow shifting
---------------------------------------------------------------------------------
-- This is the VHDL translation of the schematic in:
-- https://digsys.upc.edu/csd/P08/CLK_Generator/CLK_Generator.html
---------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
	
ENTITY CLK_Generator IS  
      PORT(	
			OSC_CLK_in	:	IN		STD_LOGIC;
			CD 			:	IN		STD_LOGIC;
			CE			:	IN		STD_LOGIC;
			CLK_A_SQ	:	OUT	STD_LOGIC;
			CLK_B_SQ	:	OUT	STD_LOGIC	
		);
END CLK_Generator;

ARCHITECTURE schematic OF CLK_Generator  IS  
-- Components
	COMPONENT Freq_Div_1250000	IS                 
		PORT(	
			CD,CLK,CE	: 	IN  std_logic;
			TC1250000	:	OUT std_logic
		);
	END COMPONENT;	

	COMPONENT Freq_Div_20 IS                 
		PORT(	
			CD,CLK,CE	: 	IN  std_logic;
			TC20		:	OUT std_logic
		);
	END COMPONENT;	

	COMPONENT T_FF IS
		Port (	
			CLK : IN	STD_LOGIC;
			CD 	: IN	STD_LOGIC;
			T	: IN	STD_LOGIC;
			Q 	: OUT	STD_LOGIC
		);
	END COMPONENT;					

-- Signals for connecting components together (just the internal wires)
	SIGNAL CLK			:	std_logic; 	-- 50 MHz
	SIGNAL Pulsed_2A	:	std_logic;	-- 40 Hz
	SIGNAL Pulsed_2B	:	std_logic;  -- 2 Hz
		
	BEGIN  
-- Instantiation of components

	Chip1	: 	Freq_Div_1250000
	PORT MAP (	   	
-- from component name 	=> to signal or port name
			CLK			=> CLK,
			CD 			=> CD,
			CE 			=> CE,
			TC1250000	=> Pulsed_2A					  
		);

	Chip2	:  Freq_Div_20
		PORT MAP (
-- from component name 	=> to signal or port name
			CLK		=> CLK,
			CD 		=> CD,
			CE 		=> Pulsed_2A,
			TC20 	=> Pulsed_2B					  
		);
	
	Chip3	: T_FF
		PORT MAP (
	-- from component name 	=> to signal or port name	
			CLK	=> CLK,
			CD 	=> CD,
			T	=> Pulsed_2A,
			Q	=> CLK_A_SQ				  
		);		


	Chip4	: T_FF
		PORT MAP (
	-- from component name 	=> to signal or port name	
			CLK		=> CLK,
			CD 		=> CD,
			T		=> Pulsed_2B,
			Q 		=> CLK_B_SQ				
		);		

	
			
-- Connections and logic between components
	-- The internal CLK form the external quartz crystal 
	CLK <= OSC_CLK_in;


	
END schematic ;
