-------------------------------------------------------------------------------- 
-- UPC - EETAC - EEL - CSD - DIGSYS https://digsys.upc.edu     
--------------------------------------------------------------------------------
-- Example of circuit adaptation to a prototyping board
-- Barrel_3_shift_reg_21bit_top including the CLK_Generator.  
-- Reference project:
-- https://digsys.upc.edu/csd/chips/legacy/DE0/Barrel_3_shifter_reg_21bit.html
---------------------------------------------------
-- Project P7  - CSD 
-- Shift registers at: 
-- https://digsys.upc.edu/csd/P07/Shift_register/Shift_Reg_4bit.html
--------------------------------------------------------------------------------

LIBRARY ieee;
USE  IEEE.STD_LOGIC_1164.all;

ENTITY Barrel_3_shift_reg_21bit_top IS
      Port (	-- Special signals
		OSC_CLK_in	: IN	STD_LOGIC;
		CD_L		: IN	STD_LOGIC;
			-- Control signal (modes of operations)
		S			: IN	STD_LOGIC_VECTOR(1 DOWNTO 0);
			-- Right and left data to 3_shift
 		R, L		: IN	STD_LOGIC_VECTOR(2 DOWNTO 0);
			-- Parallel input fixed internally to a given initial value
			-- Din : IN	STD_LOGIC_VECTOR(20 DOWNTO 0);	
			-- Select shifting CLK frequency 
		Sel_Freq	: IN	STD_LOGIC;			
			-- 7-segments (active-low)
		HEX0_L		: OUT	STD_LOGIC_VECTOR(7 DOWNTO 0);
		HEX1_L		: OUT	STD_LOGIC_VECTOR(7 DOWNTO 0);
		HEX2_L		: OUT	STD_LOGIC_VECTOR(7 DOWNTO 0);
		HEX3_L		: OUT	STD_LOGIC_VECTOR(7 DOWNTO 0);		
			-- LED (active-high)	
		LEDG		: OUT	STD_LOGIC_VECTOR(9 DOWNTO 0)
  	);
END Barrel_3_shift_reg_21bit_top;

ARCHITECTURE hierarchical_structure OF Barrel_3_shift_reg_21bit_top IS
	
-- The components to be used:
 	COMPONENT Barrel_3_shift_reg_21bit IS  
      Port (
		CLK		: IN	STD_LOGIC;
		CD		: IN	STD_LOGIC;
		S		: IN	STD_LOGIC_VECTOR(1 DOWNTO 0);
 		R, L	: IN	STD_LOGIC_VECTOR(2 DOWNTO 0);
		Din		: IN 	STD_LOGIC_VECTOR(20 DOWNTO 0);		
		Q		: OUT	STD_LOGIC_VECTOR(20 DOWNTO 0)
  	);
	END COMPONENT;
	
 	COMPONENT CLK_Generator IS  
		PORT(	
			OSC_CLK_in	: IN	STD_LOGIC;
			CD 			: IN	STD_LOGIC;
			CE			: IN	STD_LOGIC;
			CLK_A_SQ	: OUT	STD_LOGIC;
			CLK_B_SQ	: OUT	STD_LOGIC	
		);
	END COMPONENT;	

 	COMPONENT MUX_2 IS  
		PORT(	
			CH0	:IN STD_LOGIC; 
			CH1	:IN STD_LOGIC; 
			E	:IN STD_LOGIC;
			Y	:OUT STD_LOGIC;
			S	:IN STD_LOGIC 
		);
	END COMPONENT;	

-- Now the signals (wires and cables) to build the schematic 
	SIGNAL	CD, CLK, CLK_20Hz_SQ, CLK_1Hz_SQ : STD_LOGIC;
	SIGNAL	Q : STD_LOGIC_VECTOR(20 DOWNTO 0);
BEGIN

-- Instantiation of the 2 counter_mod60 
	Chip1	: Barrel_3_shift_reg_21bit  
		PORT MAP (
	-- from component name 	=> to signal or port name		
			CLK				=>	CLK,
			CD				=>	CD,				
			S				=>	S,   
			R				=>	R,
			L				=>	L,
				-- We do not have enough board switches, thus, let us connect
				-- this Din to any value
			Din				=>	"111111111111111111111",
--			Din				=>	"010101111000011110101",
			Q				=>	Q
		);

	Chip2	: CLK_Generator 
		PORT MAP (
	-- from component name 	=> to signal or port name		
			OSC_CLK_in		=>	OSC_CLK_in,
			CD				=>	CD,				
			CE				=>	'1', 
			CLK_A_SQ		=>	CLK_20Hz_SQ,
			CLK_B_SQ		=>	CLK_1Hz_SQ
		);
		
	Chip3	: MUX_2
		PORT MAP (
	-- from component name 	=> to signal or port name		
			CH0				=> 	CLK_20Hz_SQ, 
			CH1				=>	CLK_1Hz_SQ,
			E				=>	'1',
			Y				=>	CLK, 
			S				=>	Sel_Freq
		);
-- Additional connections 
	CD <= not(CD_L);

	-- Outputs 
	HEX3_L(0) <= not (Q(20));	-- a
	HEX3_L(1) <= '1';			-- b
	HEX3_L(2) <= '1';			-- c
	HEX3_L(3) <= '1';			-- d
	HEX3_L(4) <= '1';			-- e
	HEX3_L(5) <= '1';			-- f
	HEX3_L(6) <= '1';			-- g
	HEX3_L(7) <= '1';		  	-- dp

	HEX2_L(0) <= not(Q(19));	-- a
	HEX2_L(1) <= '1';			-- b
	HEX2_L(2) <= '1';			-- c
	HEX2_L(3) <= not(Q(11));	-- d
	HEX2_L(4) <= not(Q(12));	-- e
	HEX2_L(5) <= '1';			-- f
	HEX2_L(6) <= not(Q(13));	-- g
	HEX2_L(7) <= '1';		  	-- dp

	HEX1_L(0) <= not(Q(18));	-- a
	HEX1_L(1) <= '1';			-- b
	HEX1_L(2) <= '1';			-- c
	HEX1_L(3) <= not(Q(10));	-- d
	HEX1_L(4) <= '1';			-- e
	HEX1_L(5) <= '1';			-- f
	HEX1_L(6) <= not(Q(14));	-- g
	HEX1_L(7) <= '1';		  	-- dp

	HEX0_L(0) <= not(Q(17));	-- a
	HEX0_L(1) <= not(Q(16));	-- b
	HEX0_L(2) <= '1';			-- c
	HEX0_L(3) <= not(Q(9));		-- d
	HEX0_L(4) <= '1';			-- e
	HEX0_L(5) <= '1';			-- f
	HEX0_L(6) <= not(Q(15));	-- g
	HEX0_L(7) <= '1';		  	-- dp	-- not used

	LEDG(9)	<= Q(8);
	LEDG(8)	<= Q(7);
	LEDG(7)	<= Q(6);
	LEDG(6)	<= Q(5);
	LEDG(5)	<= Q(4);
	LEDG(4)	<= Q(3);
	LEDG(3)	<= Q(2);
	LEDG(2)	<= Q(1);
	LEDG(1)	<= Q(0);	

	LEDG(0) <= '0'; -- not used
	
END hierarchical_structure;
