-------------------------------------------------------------------------------
-- UPC - EETAC - DEEL -- CSD 
-- An example of barrel 21-bit 3_shift register.
-- Plan Y. Flat - single VHDL file --> Finite State Machine   
-- This is the VHDL translation of the FSM architecture discussed when planning
-- Reference page with schematics and full discussion: 
-- https://digsys.upc.edu/csd/P07/Shift_register/Shift_Reg_4bit.html#B
---------------------------------------------------
-- Project P7  - CSD 
-- http://digsys.upc.edu
--------------------------------------------------------------------------------

LIBRARY ieee;
USE  IEEE.STD_LOGIC_1164.all;

ENTITY Barrel_3_shift_reg_21bit IS
      Port (	-- Special signals
		CLK		: IN	STD_LOGIC;
		CD		: IN	STD_LOGIC;
			-- Control signal (modes of operations)
		S		: IN	STD_LOGIC_VECTOR(1 DOWNTO 0);
			-- Right and left data to 3_shift
 		R, L	: IN	STD_LOGIC_VECTOR(2 DOWNTO 0);
			-- Parallel input
		Din		: IN 	STD_LOGIC_VECTOR(20 DOWNTO 0);		
			-- Parallel output		
		Q		: OUT	STD_LOGIC_VECTOR(20 DOWNTO 0)
  	);

END Barrel_3_shift_reg_21bit;

			-- Internal description in FSM style

ARCHITECTURE FSM_like_planY OF Barrel_3_shift_reg_21bit IS
-- This is a way to label the initial state:
CONSTANT Reset : STD_LOGIC_VECTOR(20 DOWNTO 0) := "000000000000000000000"; 

-- Internal wires --> in this case just the present and future state signals
SIGNAL current_state,next_state: STD_LOGIC_VECTOR(20 DOWNTO 0);

BEGIN
------------------------- State register 
-- The only clocked block,essentially a set of D-type flip-flops in parallel
-- The asynchronous reset has precedence over the CLK
State_Register: PROCESS (CD, CLK, next_state)
	BEGIN

	IF CD = '1' THEN
	-- reset counter ( an asynchronous reset that we call "Clear Direct"
		current_state <= Reset; 
	ELSIF (CLK'EVENT and CLK = '1') THEN 
	-- Synchronous register (D-type flip-flop)
		current_state <= next_state; 
	END IF;

END PROCESS State_Register;

-- CC1 ---------- Combinational circuit for calculating next state
-- This is the translation of the plan B flowchart interpretation of the 
-- truth table
CC1: PROCESS (current_state, Din, S, L, R)
	BEGIN
	IF S = "11" THEN 	
		next_state <= Din; -- parallel input (data register)

	ELSIF S="01" THEN  -- shift right 3-bit 
		next_state(0) 	<= current_state(3);
		next_state(1) 	<= current_state(4);
		next_state(2) 	<= current_state(5);
		next_state(3) 	<= current_state(6);
		next_state(4) 	<= current_state(7);
		next_state(5) 	<= current_state(8);
		next_state(6) 	<= current_state(9);
		next_state(7) 	<= current_state(10);
		next_state(8) 	<= current_state(11);
		next_state(9) 	<= current_state(12);
		next_state(10) 	<= current_state(13);
		next_state(11) 	<= current_state(14);
		next_state(12) 	<= current_state(15);
		next_state(13) 	<= current_state(16);
		next_state(14) 	<= current_state(17);
		next_state(15) 	<= current_state(18);
		next_state(16) 	<= current_state(19);
		next_state(17) 	<= current_state(20);
		next_state(18) 	<= R(0);
		next_state(19) 	<= R(1);
		next_state(20) 	<= R(2);


	ELSIF S="10" THEN -- shift left
		next_state(20) 	<= current_state(17);
		next_state(19) 	<= current_state(16);
		next_state(18) 	<= current_state(15);
		next_state(17) 	<= current_state(14);
		next_state(16) 	<= current_state(13);
		next_state(15) 	<= current_state(12);
		next_state(14) 	<= current_state(11);
		next_state(13) 	<= current_state(10);
		next_state(12) 	<= current_state(9);
		next_state(11) 	<= current_state(8);
		next_state(10) 	<= current_state(7);
		next_state(9) 	<= current_state(6);
		next_state(8) 	<= current_state(5);
		next_state(7) 	<= current_state(4);
		next_state(6) 	<= current_state(3);
		next_state(5) 	<= current_state(2);
		next_state(4) 	<= current_state(1);
		next_state(3) 	<= current_state(0);
		next_state(2) 	<= L(2);
		next_state(1) 	<= L(1);
		next_state(0) 	<= L(0);
	
	ELSE 	
		next_state <= current_state; -- do nothing

	END IF;

END PROCESS CC1;
--------------------------------------------------------------------------------
--- CC2 ------------Combinational circuit for calculating the outputs
-- In this case, simple buffers to copy the internal states into entity pins
Q <= current_state; 

END FSM_like_planY;





