#ifndef PCF8574_H
#define	PCF8574_H


/**
  Section: Included Files
 */
#include "mcc_generated_files/system/system.h"

// PCF8574 client in I2C tutorial step #2
// To run and configure the new I2C client PCF8574
// This is the client 7-bit hexadecimal address without R/W_L
// When writing to the client the host adds the R/W_L bit '0'
#define PCF8574_I2C_CLIENT1_ADDR	0x26// for writing directly to the port 

// PCF8574 client in LCD - I2C tutorial step #1
// Default PCF8574 I2C-LCD kit address 
#define PCF8574_I2C_CLIENT2_ADDR	0x27 // Send commands and data to the LCD 

#define PCF8574_PINS_DIGITAL_HIGH	0xFF
#define PCF8574_PINS_DIGITAL_LOW	0x00
#define PCF8574_DATALENGTH			1


//-----------[ Functions' Prototypes ]--------------


void IO_Expander_Write(uint8_t Data);

// Other IO expander functions...


#endif	/* PCF8574_H */
