// I2C - LCD LIBRARY 
// MCC Melody MSSP (I2C-SPI) peripheral module
// Adapted from examples in the following tutorial: 
// https://deepbluembedded.com/interfacing-i2c-lcd-16x2-tutorial-with-pic-microcontrollers-mplab-xc8/

// The adaptation consist on replacing the MCP23S17 16-bit SPI expander 
// using in the Explorer 8 schematic to connect the LM1602 LCD, by the PCF8574
// 8-bit I2C expander. The software is the MCC Melody I2C library generated
// selecting the MSSPx peripherals. 

/**
  Section: Included Files
 */

#include "PCF8574.h"

uint8_t RS, i2c_add;

const i2c_host_interface_t *I2C = &i2c2_host_host_interface;


//---------------[ LCD Routines ]----------------
//-----------------------------------------------
void IO_Expander_Write(uint8_t Data)
{
	// I2C MSSPx functions from MCC Melody 
	
	//Data = Data | BackLight_State;
			// Delay 0.5 s
//	__delay_ms(500);
	if (I2C->Write(PCF8574_I2C_CLIENT2_ADDR, &Data, PCF8574_DATALENGTH)){
		while(I2C->IsBusy()){
			I2C->Tasks();
		}
		if (I2C->ErrorGet() == I2C_ERROR_NONE){
			/* Write operation is successful */
		}
		else {
			/* Error handling */
		}
	}
}
