#ifndef I2C_LCD_H
#define	I2C_LCD_H

/**
  Section: Included Files
 */
#include "mcc_generated_files/system/system.h"

#include "mcc_generated_files/i2c_host/i2c_host_types.h"
#include "mcc_generated_files/i2c_host/mssp2.h"

/**
  Section: Macro Declarations, LCD commands
 */
#define LCD_BACKLIGHT_ON		0x08
#define LCD_BACKLIGHT_OFF		0x00
#define LCD_FIRST_ROW			0x80
#define LCD_SECOND_ROW			0xC0
#define LCD_THIRD_ROW			0x94
#define LCD_FOURTH_ROW			0xD4
#define LCD_CLEAR				0x01
#define LCD_RETURN_HOME			0x02
#define LCD_ENTRY_MODE_SET		0x04
#define LCD_CURSOR_OFF			0x0C
#define LCD_CURSOR_ON			0x0E
#define LCD_BLINK_CURSOR_ON		0x0F
#define LCD_BLINK_CURSOR_OFF	0x0E
#define LCD_MOVE_CURSOR_LEFT	0x10
#define LCD_MOVE_CURSOR_RIGHT	0x14
#define LCD_TURN_ON				0x0C
#define LCD_TURN_OFF			0x08
#define LCD_SHIFT_LEFT			0x18
#define LCD_SHIFT_RIGHT			0x1C
#define LCD_TYPE				2		// 0 -> 5x7 | 1 -> 5x10 | 2 -> 2 lines


//-----------[ Function prototypes ]--------------


void LCD_Init(uint8_t I2C_Add);
void LCD_Write_4Bit(uint8_t Nibble);
void LCD_CMD(uint8_t CMD);
void LCD_Set_Cursor(uint8_t ROW, uint8_t COL);
void LCD_Write_Char(char);
void LCD_Write_String(char*);
void LCD_Backlight_ON(void);
void LCD_Backlight_OFF(void);
void LCD_SR_Display(void);
void LCD_SL_Display(void);
void LCD_SR_Cursor(void);
void LCD_SL_Cursor(void);
void LCD_Cursor_ON(void);
void LCD_Cursor_OFF(void);
void LCD_Blink_Cursor(void);
void LCD_Blink_Cursor_OFF(void);
void LCD_Clear(void);


#endif	/* I2C_LCD_H */
