/**
 * PWM5 Generated Driver API Header File.
 * 
 * @file ccp5.h
 * 
 * @defgroup pwm5 PWM5
 * 
 * @brief This file contains the API prototypes for the PWM5 module.
 *
 * @version PWM5 Driver Version 1.1.0
*/
/*
 [2026] Microchip Technology Inc. and its subsidiaries.

    Subject to your compliance with these terms, you may use Microchip 
    software and any derivatives exclusively with Microchip products. 
    You are responsible for complying with 3rd party license terms  
    applicable to your use of 3rd party software (including open source  
    software) that may accompany Microchip software. SOFTWARE IS ?AS IS.? 
    NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS 
    SOFTWARE, INCLUDING ANY IMPLIED WARRANTIES OF NON-INFRINGEMENT,  
    MERCHANTABILITY, OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT 
    WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY 
    KIND WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF 
    MICROCHIP HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE 
    FORESEEABLE. TO THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP?S 
    TOTAL LIABILITY ON ALL CLAIMS RELATED TO THE SOFTWARE WILL NOT 
    EXCEED AMOUNT OF FEES, IF ANY, YOU PAID DIRECTLY TO MICROCHIP FOR 
    THIS SOFTWARE.
*/

#ifndef PWM5_H
#define PWM5_H

 /**
   Section: Included Files
 */

#include <xc.h>
#include <stdint.h>
#include <stdbool.h>


 /**
 * @ingroup pwm5
 * @brief Initializes the CCP5 module. This is called only once before calling other CCP5 APIs.
 * @param None.
 * @return None.
 */
void CCP5_Initialize(void);

/**
 * @ingroup pwm5
 * @brief Loads the 16-bit duty cycle value.
 * @pre CCP5_Initialize() is already called.
 * @param dutyValue - 16-bit duty cycle value.
 * @return None.
 */
void CCP5_LoadDutyValue(uint16_t dutyValue);

#endif //PWM5_H
/**
 End of File
*/
