--------------------------------------------------------------------------------
-- UPC - EETAC - EEL - CSD - P6 - http://digsys.upc.edu
--------------------------------------------------------------------------------
-- Demonstration of a FSM acting as a digital low-pass filter for eliminating
-- the electrical noise associated to keys or push-buttons click and release 
-- actions. 
-- A synchronous Moore FSM coded using CSD style and conventions.
-- This VHDL file is the translation of the FSM state register, CC1 and CC2 
-- truth tables and flowcharts explained in the tutorial at:
-- http://digsys.upc.edu/csd/P06/P6_T/Debouncing/Debouncing_filter.html
-- 
-- The input is active-low PB_L
-- CLK frequency has to be ajusted to the phenomena (100 Hz -- 200 Hz) 
--------------------------------------------------------------------------------
LIBRARY ieee;     
USE  IEEE.STD_LOGIC_1164.all;
			
ENTITY debouncing_filter IS
      Port (	CLK 	: IN	STD_LOGIC;
				PB_L	: IN	STD_LOGIC;
				CD   	: IN 	STD_LOGIC;
				QA 		: OUT	STD_LOGIC;
				QB		: OUT	STD_LOGIC
	);
END debouncing_filter;

ARCHITECTURE FSM_like OF debouncing_filter IS

---- FSM signals 
	TYPE State_type IS (Idle, One_zero_detected, Two_zeroes_detected, 
						Three_zeroes_detected, Key_presed, One_high);  

	SIGNAL current_state, next_state	: State_type ; 

BEGIN
--------------------------------------------------------------------------------
state_register: PROCESS (CD, CLK, next_state)
	BEGIN			
		IF CD = '1' THEN  -- asynchronous reset
			current_state <= Idle; 
		ELSIF (CLK'EVENT and CLK = '1') THEN	
			current_state <= next_state; -- Synchronous r-bit memory cell (D_FF)
		END IF;
END PROCESS state_register;

------------------------- CC1: Combinational system for calculating next state
--------------------------------------------------------------------------------
CC_1: PROCESS (current_state, PB_L)
	BEGIN
	   
		CASE current_state IS
				
			WHEN Idle =>
			   IF (PB_L = '1') THEN
			      	next_state <= Idle; 
				ELSE    
					next_state <= One_zero_detected;
				END IF;
				
			WHEN One_zero_detected => 
				IF (PB_L = '1') THEN
					next_state <= Idle; 
				ELSE    
					next_state <= Two_zeroes_detected ;
				END IF;
				
			WHEN Two_zeroes_detected => 
			   IF (PB_L = '1') THEN
					next_state <= idle; 
				ELSE    
					next_state <= Three_zeroes_detected ;
				END IF;
				
			WHEN Three_zeroes_detected => 
					next_state <= key_presed ;
					
			WHEN Key_presed => 
			   IF (PB_L = '0') THEN
					next_state <= Key_presed; 
				ELSE    
					next_state <= One_high ;
				END IF;
				
			WHEN One_high => 
			   IF (PB_L = '1') THEN
					next_state <= Idle; 
				ELSE    
					next_state <= Key_presed ;
				END IF;
		END CASE ;		
END PROCESS CC_1;
--------------------------------------------------------------------------------
-- CS_2: combinational system for calculating outputs
-- In a Moore FSM all the outputs are synchronous  Z = f (S)
CC_2: PROCESS (current_state)
	BEGIN
		CASE current_state IS
				WHEN Idle => 
					QA <= '0';
					QB <= '0';
				WHEN One_zero_detected => 
					QA <= '0';
					QB <= '0';
				WHEN Two_zeroes_detected => 
					QA <= '0';
					QB <= '0';
				WHEN Three_zeroes_detected => 
					QA <= '1';
					QB <= '1';
				WHEN Key_presed => 
					QA <= '0';
					QB <= '1';
				WHEN One_high => 
					QA <= '0';
					QB <= '1';
		END CASE ;		
END PROCESS CC_2;

-- Place other logic if necessary

END FSM_like;