--------------------------------------------------------------------------------
-- UPC - EETAC - EEL - CSD - P6 - http://digsys.upc.edu
--------------------------------------------------------------------------------
-- Demonstration of a FSM to generate a single pulse from an incoming
-- signal of any duration. 
-- A synchronous Moore FSM coded using CSD style and conventions.
-- This VHDL file is the translation of the FSM state register, CC1 and CC2 
-- truth tables and flowcharts explained in the tutorial at:
-- https://digsys.upc.edu/csd/P06/Debouncing/Debouncing_filter.html#B
-- 
-- -----------------------------------------------------------------------------
LIBRARY ieee;     
USE  IEEE.STD_LOGIC_1164.all;
			
ENTITY Pulse_gen IS
	Port (
		CLK 	: IN	STD_LOGIC;
		CD   	: IN 	STD_LOGIC;
		D 		: IN	STD_LOGIC;
		Q		: OUT	STD_LOGIC
	);
END Pulse_gen;

ARCHITECTURE FSM_like OF Pulse_gen IS

---- FSM signals 
	TYPE State_type IS (Idle, Pulse_ON, Wait_release);  

	SIGNAL current_state, next_state	: State_type ; 

BEGIN
--------------------------------------------------------------------------------
state_register: PROCESS (CD, CLK, next_state)
	BEGIN			
		IF CD = '1' THEN  -- asynchronous reset
			current_state <= Idle; 
		ELSIF (CLK'EVENT and CLK = '1') THEN
			current_state <= next_state; -- Synchronous r-bit memory cell (D_FF)
		END IF;
END PROCESS state_register;

------------------------- CC1: Combinational system for calculating next state
--------------------------------------------------------------------------------
CC_1: PROCESS (current_state, D)
BEGIN
	CASE current_state IS
		WHEN Idle =>
			IF (D = '1') THEN
				next_state <= Pulse_ON; 
			ELSE
				next_state <= Idle;
			END IF;

			WHEN Pulse_ON => 
					next_state <= Wait_release; 

			WHEN Wait_release => -- Wait here until the user releases the key
				IF (D = '1') THEN
					next_state <= Wait_release; 
			ELSE 
					next_state <= Idle;
			END IF;
	END CASE ;
END PROCESS CC_1;
--------------------------------------------------------------------------------
-- CS_2: combinational system for calculating outputs
-- In a Moore FSM all the outputs are synchronous  Z = f (S)
CC_2: PROCESS (current_state)
BEGIN
	CASE current_state IS
		WHEN Idle 		=> 
			Q <= '0';
		WHEN Pulse_ON	=> 
			Q <= '1';
		WHEN Wait_release => 
			Q <= '0';
		END CASE ;
END PROCESS CC_2;

-- Place other logic if necessary

END FSM_like;