--------------------------------------------------------------------------------
-- UPC - EETAC - DEEL - CSD - DEE
---------------------------------------------------
-- Example of a dedicated processor translated using plan C2
-- Programmable Pulse Width Modulator (PWM) based on PIC TMR2-PWM architecture
-- This descriptions is the translation of Fig. 16 at the reference project:  
-- https://digsys.upc.edu/csd/DEE/dimmer/phaseB/FPGA/Dimmer_FPGA.html

--------------------------------------------------------------------------------
LIBRARY ieee ;
USE ieee.std_logic_1164.all ;

ENTITY PWM_top2 IS  
	PORT (
		OSC_CLK_in	: IN	STD_LOGIC;
		CD_L		: IN	STD_LOGIC;	-- active-low key
		WP			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); -- waveform period
		ST_L		: IN	STD_LOGIC; --start/stop pus-button pulse active-low
		PWM_out		: OUT	STD_LOGIC; -- LED(9)
		PWM_out_L	: OUT	STD_LOGIC; -- LED(0)
		PWM_out_TP_L: OUT	STD_LOGIC; 
		PWM_out_TP	: OUT	STD_LOGIC; -- replicated output for lab measurements
		PWU_L		: IN	STD_LOGIC; --new push-buttons to set the pulse width 
		PWD_L		: IN	STD_LOGIC; 
		LED_L		: OUT STD_LOGIC_VECTOR(8 downto 1) --Unused LED
	);
	END PWM_top2; 

ARCHITECTURE dedicated_processor OF PWM_top2 IS

COMPONENT PWM IS
	PORT (
		CLK			: IN	STD_LOGIC;
		CD			: IN	STD_LOGIC;
		WP			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --wave period
		PW			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --pulse width 
		ST			: IN	STD_LOGIC; -- start/stop pulse
		PWM_out		: OUT	STD_LOGIC;
		PWM_out_L	: OUT	STD_LOGIC
	);
END COMPONENT;


COMPONENT CLK_Generator IS
	PORT(	
		OSC_CLK_in	: IN		STD_LOGIC;
		CD 			: IN		STD_LOGIC;
		CE			: IN		STD_LOGIC;
		CLK_A_SQ	: OUT		STD_LOGIC;
		CLK_B_SQ	: OUT		STD_LOGIC
	);
END COMPONENT;


COMPONENT Debouncing_filter IS
	Port (
		CLK		: IN	STD_LOGIC;
		PB_L	: IN	STD_LOGIC;
		CD		: IN 	STD_LOGIC;
		QA		: OUT	STD_LOGIC;
		QB		: OUT	STD_LOGIC
	);
END COMPONENT;

COMPONENT Pulse_gen IS
	Port (
		CLK		: IN	STD_LOGIC;
		CD		: IN 	STD_LOGIC;
		D		: IN	STD_LOGIC;
		Q		: OUT	STD_LOGIC
	);
END COMPONENT;

COMPONENT Counter_mod1024 IS
	Port (
		CLK		: IN	STD_LOGIC;
		CD		: IN	STD_LOGIC;
		Din		: IN 	STD_LOGIC_VECTOR(9 DOWNTO 0);
		LD		: IN	STD_LOGIC;
		CE		: IN	STD_LOGIC;
		UD_L	: IN	STD_LOGIC;
		Q		: OUT	STD_LOGIC_VECTOR(9 DOWNTO 0);
		TC1024	: OUT	STD_LOGIC
	);END COMPONENT;

	SIGNAL CLK, CLK_PB			: STD_LOGIC;
	SIGNAL QB,PB, ST, CD		: STD_LOGIC;
	SIGNAL W, W_L				: STD_LOGIC;
	SIGNAL CE, UD_L, CD1, TC1024: STD_LOGIC;
	-- This time the PW signal is generated by the counter Chip5
	SIGNAL PW 					: STD_LOGIC_VECTOR(9 DOWNTO 0);
	
BEGIN
-- Instantiation of components

Chip1:	PWM
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK			=> CLK,
		CD			=> CD, 
		WP			=> WP,--Waveform period (adjustable using switches)
		PW			=> PW,
		ST			=> ST,
		PWM_out		=> W,-- to replicate the output pins (LED and test-point)
		PWM_out_L	=> W_L
	);
	
Chip4:	CLK_Generator
-- from component name 	=> to signal or port name	
	PORT MAP (
		OSC_CLK_in		=> OSC_CLK_in,
		CD				=> CD, 
		CE				=> '1',
		CLK_A_SQ		=> CLK,
		CLK_B_SQ		=> CLK_PB
	);


Chip2:	Debouncing_filter
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK				=> CLK_PB,--a low-freq for sampling the button (200 Hz)
		PB_L			=> ST_L, 
		CD				=> CD,
		QA				=> PB,
		QB				=> QB
	);

Chip3:	Pulse_gen
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK				=> CLK,
		CD				=> CD,
		D				=> PB,
		Q				=> ST
	);


Chip5:	Counter_mod1024
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK				=> CLK_PB,-- 200 Hz to sweep all values in 5s
		CD				=> CD1,
		Din				=> "0000000000",
		LD				=> '0', -- not used
		CE				=> CE, 
		UD_L			=> UD_L, 
		Q				=> PW,-- Pulse width generated by the counter UP/DOWN
		TC1024			=> TC1024
	);

	-- The unused LED will be reset
	LED_L 		<= "00000000";
	CD 			<= not(CD_L);
	PWM_out 	<= W;
	PWM_out_L	<= W_L;
	PWM_out_TP	<= W; -- replicated
	PWM_out_TP_L<= W_L; -- replicated
	
	-- The logic to control the new counter that will set PW
	CE 		<= PWU_L xor PWD_L;
	UD_L 	<= not(PWU_L) and PWD_L;
	CD1 	<= 	not(PWU_L) and not(PWD_L);
	
END dedicated_processor;
