-------------------------------------------------------------------------------- 
-- UPC - EETAC - CSD - DIGSYS       
--------------------------------------------------------------------------------
-- Plan C1: Synchronous FSM, multiple blocks (processes) in a single VHDL file
-- Our representation of a FSM is described at lecture: 
-- https://digsys.upc.edu/csd/P06/L06_1/L6_1.html

-- This schematic is the translation of the FSM used in: 
-- https://digsys.upc.edu/csd/DEE/dimmer/phaseB/FPGA/Dimmer_FPGA.html
--------------------------------------------------------------------------------

LIBRARY ieee;     
USE  IEEE.STD_LOGIC_1164.all;
USE  IEEE.STD_LOGIC_UNSIGNED.all;
			
ENTITY FSM IS
	Port (
		CLK			: IN	STD_LOGIC;
		CD			: IN	STD_LOGIC;
		ST			: IN	STD_LOGIC;
		WR			: IN	STD_LOGIC;
		WS			: IN	STD_LOGIC;
		LDR			: OUT	STD_LOGIC;
		CE			: OUT	STD_LOGIC;
		W			: OUT	STD_LOGIC
	);
END FSM;

ARCHITECTURE plan_C1 OF FSM IS

	TYPE State_type IS (Idle, Load_regs, Wave_ON, Wave_OFF);  

	SIGNAL current_state, next_state	: State_type ; 	
------------------------------------------------------------------------------
-- Using VHDL tools for synthesis, we can choose how to encode these states: 
-- "one_hot", "sequential", "Johnson", "gray", etc. 

BEGIN
--------------------------------------------------------------------------------
	-------- The state register that contains the memory cells
state_register: PROCESS (CD, CLK, next_state)
BEGIN					
	IF CD = '1' THEN 
		current_state <= Idle;-- reset state if CD level high is asserted  
	ELSIF (CLK'EVENT and CLK = '1') THEN	-- Synchronous D-type flip-flops
		current_state <= next_state; 
	END IF;
END PROCESS state_register;

	-------- CC1: Combinational system for calculating next state
	-------- The truth table that contains all the state transitions (arrows)
--------------------------------------------------------------------------------
CC_1: PROCESS (current_state, WS, WR, ST)
BEGIN
	CASE current_state IS
		WHEN Idle =>
			IF (ST = '1') THEN
				next_state <= Load_regs;	
			ELSE    
				next_state <= Idle; 
			END IF;
			
		WHEN Load_regs =>
				next_state <= Wave_ON; 

		WHEN Wave_ON =>  
			IF (ST = '1') THEN
				next_state <= Idle; 
			ELSIF(WR = '1') THEN
				next_state <= Wave_OFF;
			ELSE
				next_state <= Wave_ON; --until the Counter count is PW
			END IF;

		WHEN Wave_OFF =>  
			IF (ST = '1') THEN
				next_state <= Idle; 
			ELSIF(WS = '1') THEN
				next_state <= Load_regs;
			ELSE
				next_state <= Wave_OFF; --until the Counter count is WP
			END IF;


	END CASE ;

END PROCESS CC_1;

--------------------------------------------------------------------------------
	-------- CC_2: combinational system for calculating the outputs 
	-------- The truth table that contains all the signals in red brackets
CC_2: PROCESS (current_state)
BEGIN
	CASE current_state IS
		WHEN Idle => 
			LDR		<= '0'; -- no activity, off
			CE		<= '0'; 
			W		<= '0';

		WHEN Load_regs => -- capture new values for WP, PW and reset counter
			LDR		<= '1';
			CE		<= '0'; -- It can be '-' don't care
			W		<= '0';

		WHEN Wave_ON => 
			LDR		<= '0';
			CE		<= '1'; -- counting 
			W		<= '1'; -- Wave high 

		WHEN Wave_OFF => 
			LDR		<= '0';
			CE		<= '1'; -- Counting 
			W		<= '0'; -- wave low


		END CASE ;

END PROCESS CC_2;

-- Place here other logic if necessary

END plan_C1;