--------------------------------------------------------------------------------
-- UPC - EETAC - DEEL - CSD - DEE
---------------------------------------------------
-- Example of datapath or operational unit for a dedicated processor 
-- translated using plan C2
-- The datapath components used are adapted from CSD
-- Programmable Pulse Width Modulator (PWM) based on PIC TMR2-PWM architecture
-- This descriptions is the translation of Fig. 4 at the reference project:  
-- https://digsys.upc.edu/csd/DEE/dimmer/phaseB/FPGA/Dimmer_FPGA.html

--------------------------------------------------------------------------------

LIBRARY ieee ;
USE ieee.std_logic_1164.all ;

ENTITY Datapath IS  
	PORT (
		CLK			: IN	STD_LOGIC;
		CD			: IN	STD_LOGIC;
		WP			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --wave period
		PW			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --pulse width 
		LDR			: IN 	STD_LOGIC; -- to load new PW and WP values 
		CE			: IN 	STD_LOGIC; -- to enable or disable counting 
		WS			: OUT	STD_LOGIC; -- status signal
		WR			: OUT	STD_LOGIC; -- status signal
		QCounter	: OUT	STD_LOGIC_VECTOR (9 DOWNTO 0)
	);
	END Datapath; 


ARCHITECTURE structure_planC2 OF Datapath IS
    
COMPONENT Data_reg_10bit IS
	Port (	
		CLK	: IN	STD_LOGIC;
		CD	: IN	STD_LOGIC;
		LD	: IN	STD_LOGIC;
		Din	: IN 	STD_LOGIC_VECTOR(9 DOWNTO 0);
		Q	: OUT	STD_LOGIC_VECTOR(9 DOWNTO 0)
	);
END COMPONENT;

COMPONENT Counter_mod1024 IS
	Port (	
		CLK		: IN	STD_LOGIC;
		CD		: IN	STD_LOGIC;
		Din		: IN 	STD_LOGIC_VECTOR(9 DOWNTO 0);
		LD		: IN	STD_LOGIC;
		CE		: IN	STD_LOGIC;
		UD_L	: IN	STD_LOGIC;
		Q		: OUT	STD_LOGIC_VECTOR(9 DOWNTO 0);
		TC1024	: OUT	STD_LOGIC
	);
END COMPONENT;

COMPONENT Comp_10bit IS
	PORT (
		A, B		: IN	STD_LOGIC_VECTOR(9 DOWNTO 0);
		Gi, Ei, Li	: IN	STD_LOGIC;
		GT, EQ, LT	: OUT	STD_LOGIC
	); 
END COMPONENT;

	SIGNAL  TC1024		: STD_LOGIC;-- output not used 
	SIGNAL  LT1, LT2	: STD_LOGIC;-- outputs not used 
	SIGNAL  GT1, GT2	: STD_LOGIC;-- outputs not used 
	SIGNAL  QC, WPR, PWR: STD_LOGIC_VECTOR (9 DOWNTO 0); 

BEGIN

-- Instantiation of components
Chip1	:	Counter_mod1024
--	from component name => to signal or port name	
	PORT MAP (
		CLK				=> CLK,
		CD				=> CD,
		Din				=> "0000000000", -- This is a sync reset 
		UD_L			=> '1',
		CE				=> CE,
		LD				=> LDR, -- In this case, it resets the counter
		TC1024			=> TC1024,
		Q				=> QC
	);
	
Chip2	:	Comp_10bit
--	from component name => to signal or port name	
	PORT MAP (
		A				=> QC,
		B				=> WPR,
		Gi				=> '0',
		Ei				=> '1',
		Li				=> '0',
		GT				=> GT1, 	--nc 
		EQ				=> WS, -- status signal to set the output high 
		LT				=> LT1 		--nc 
	);

Chip3	:	Data_reg_10bit
--	from component name => to signal or port name	
	PORT MAP (
		CLK				=> CLK,
		CD				=> CD,
		LD				=> LDR,
		Din				=> WP,		-- Set the period T_ON = (WP+1)·TCLK
		Q				=> WPR		-- WP value registered
	);

Chip4	:	Comp_10bit
--	from component name => to signal or port name	
	PORT MAP (
		A				=> QC,
		B				=> PWR,
		Gi				=> '0',
		Ei				=> '1',
		Li				=> '0',
		GT				=> GT2, 	--nc
		EQ				=> WR, 	-- status signal to finish T_ON
		LT				=> LT2		--nc 
	);	

Chip5	:	Data_reg_10bit
--	from component name => to signal or port name	
	PORT MAP (
		CLK				=> CLK,
		CD				=> CD,
		LD				=> LDR,
		Din				=> PW,	-- Set the T_ON duration = (PW+1)·TCLK
		Q				=> PWR 	-- PW value registered
	);

QCounter <= QC; 

END structure_planC2 ;
