-- Copyright (C) 2020  Intel Corporation. All rights reserved.
-- Your use of Intel Corporation's design tools, logic functions 
-- and other software and tools, and any partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Intel Program License 
-- Subscription Agreement, the Intel Quartus Prime License Agreement,
-- the Intel FPGA IP License Agreement, or other applicable license
-- agreement, including, without limitation, that your use is for
-- the sole purpose of programming logic devices manufactured by
-- Intel and sold by Intel or its authorized distributors.  Please
-- refer to the applicable agreement for further details, at
-- https://fpgasoftware.intel.com/eula.

-- VENDOR "Altera"
-- PROGRAM "Quartus Prime"
-- VERSION "Version 20.1.1 Build 720 11/11/2020 SJ Lite Edition"

-- DATE "01/13/2026 00:46:12"

-- 
-- Device: Altera 10M50DAF484C7G Package FBGA484
-- 

-- 
-- This VHDL file should be used for ModelSim-Altera (VHDL) only
-- 

LIBRARY FIFTYFIVENM;
LIBRARY IEEE;
USE FIFTYFIVENM.FIFTYFIVENM_COMPONENTS.ALL;
USE IEEE.STD_LOGIC_1164.ALL;

ENTITY 	hard_block IS
    PORT (
	devoe : IN std_logic;
	devclrn : IN std_logic;
	devpor : IN std_logic
	);
END hard_block;

-- Design Ports Information
-- ~ALTERA_TMS~	=>  Location: PIN_H2,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_TCK~	=>  Location: PIN_G2,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_TDI~	=>  Location: PIN_L4,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_TDO~	=>  Location: PIN_M5,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- ~ALTERA_CONFIG_SEL~	=>  Location: PIN_H10,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- ~ALTERA_nCONFIG~	=>  Location: PIN_H9,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_nSTATUS~	=>  Location: PIN_G9,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_CONF_DONE~	=>  Location: PIN_F8,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default


ARCHITECTURE structure OF hard_block IS
SIGNAL gnd : std_logic := '0';
SIGNAL vcc : std_logic := '1';
SIGNAL unknown : std_logic := 'X';
SIGNAL ww_devoe : std_logic;
SIGNAL ww_devclrn : std_logic;
SIGNAL ww_devpor : std_logic;
SIGNAL \~ALTERA_TMS~~padout\ : std_logic;
SIGNAL \~ALTERA_TCK~~padout\ : std_logic;
SIGNAL \~ALTERA_TDI~~padout\ : std_logic;
SIGNAL \~ALTERA_CONFIG_SEL~~padout\ : std_logic;
SIGNAL \~ALTERA_nCONFIG~~padout\ : std_logic;
SIGNAL \~ALTERA_nSTATUS~~padout\ : std_logic;
SIGNAL \~ALTERA_CONF_DONE~~padout\ : std_logic;
SIGNAL \~ALTERA_TMS~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_TCK~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_TDI~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_CONFIG_SEL~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_nCONFIG~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_nSTATUS~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_CONF_DONE~~ibuf_o\ : std_logic;

BEGIN

ww_devoe <= devoe;
ww_devclrn <= devclrn;
ww_devpor <= devpor;
END structure;


LIBRARY ALTERA;
LIBRARY FIFTYFIVENM;
LIBRARY IEEE;
USE ALTERA.ALTERA_PRIMITIVES_COMPONENTS.ALL;
USE FIFTYFIVENM.FIFTYFIVENM_COMPONENTS.ALL;
USE IEEE.STD_LOGIC_1164.ALL;

ENTITY 	PWM_top IS
    PORT (
	OSC_CLK_in : IN std_logic;
	CD_L : IN std_logic;
	PW : IN std_logic_vector(9 DOWNTO 0);
	ST_L : IN std_logic;
	PWM_out : OUT std_logic;
	PWM_out_L : OUT std_logic;
	LED_L : OUT std_logic_vector(8 DOWNTO 1);
	PWM_out_TP : OUT std_logic
	);
END PWM_top;

-- Design Ports Information
-- PWM_out	=>  Location: PIN_B11,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PWM_out_L	=>  Location: PIN_A8,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- LED_L[1]	=>  Location: PIN_A9,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- LED_L[2]	=>  Location: PIN_A10,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- LED_L[3]	=>  Location: PIN_B10,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- LED_L[4]	=>  Location: PIN_D13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- LED_L[5]	=>  Location: PIN_C13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- LED_L[6]	=>  Location: PIN_E14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- LED_L[7]	=>  Location: PIN_D14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- LED_L[8]	=>  Location: PIN_A11,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PWM_out_TP	=>  Location: PIN_C9,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- CD_L	=>  Location: PIN_B8,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[1]	=>  Location: PIN_C11,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[0]	=>  Location: PIN_C10,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[9]	=>  Location: PIN_F15,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[8]	=>  Location: PIN_B14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[6]	=>  Location: PIN_A13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[7]	=>  Location: PIN_A14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[5]	=>  Location: PIN_B12,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[4]	=>  Location: PIN_A12,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[3]	=>  Location: PIN_C12,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[2]	=>  Location: PIN_D12,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- OSC_CLK_in	=>  Location: PIN_N14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- ST_L	=>  Location: PIN_A7,	 I/O Standard: 2.5 V,	 Current Strength: Default


ARCHITECTURE structure OF PWM_top IS
SIGNAL gnd : std_logic := '0';
SIGNAL vcc : std_logic := '1';
SIGNAL unknown : std_logic := 'X';
SIGNAL devoe : std_logic := '1';
SIGNAL devclrn : std_logic := '1';
SIGNAL devpor : std_logic := '1';
SIGNAL ww_devoe : std_logic;
SIGNAL ww_devclrn : std_logic;
SIGNAL ww_devpor : std_logic;
SIGNAL ww_OSC_CLK_in : std_logic;
SIGNAL ww_CD_L : std_logic;
SIGNAL ww_PW : std_logic_vector(9 DOWNTO 0);
SIGNAL ww_ST_L : std_logic;
SIGNAL ww_PWM_out : std_logic;
SIGNAL ww_PWM_out_L : std_logic;
SIGNAL ww_LED_L : std_logic_vector(8 DOWNTO 1);
SIGNAL ww_PWM_out_TP : std_logic;
SIGNAL \~QUARTUS_CREATED_ADC1~_CHSEL_bus\ : std_logic_vector(4 DOWNTO 0);
SIGNAL \~QUARTUS_CREATED_ADC2~_CHSEL_bus\ : std_logic_vector(4 DOWNTO 0);
SIGNAL \Chip4|Chip4|current_state~clkctrl_INCLK_bus\ : std_logic_vector(3 DOWNTO 0);
SIGNAL \Chip4|Chip2|current_state~clkctrl_INCLK_bus\ : std_logic_vector(3 DOWNTO 0);
SIGNAL \OSC_CLK_in~inputclkctrl_INCLK_bus\ : std_logic_vector(3 DOWNTO 0);
SIGNAL \~QUARTUS_CREATED_GND~I_combout\ : std_logic;
SIGNAL \~QUARTUS_CREATED_UNVM~~busy\ : std_logic;
SIGNAL \~QUARTUS_CREATED_ADC1~~eoc\ : std_logic;
SIGNAL \~QUARTUS_CREATED_ADC2~~eoc\ : std_logic;
SIGNAL \PWM_out~output_o\ : std_logic;
SIGNAL \PWM_out_L~output_o\ : std_logic;
SIGNAL \LED_L[1]~output_o\ : std_logic;
SIGNAL \LED_L[2]~output_o\ : std_logic;
SIGNAL \LED_L[3]~output_o\ : std_logic;
SIGNAL \LED_L[4]~output_o\ : std_logic;
SIGNAL \LED_L[5]~output_o\ : std_logic;
SIGNAL \LED_L[6]~output_o\ : std_logic;
SIGNAL \LED_L[7]~output_o\ : std_logic;
SIGNAL \LED_L[8]~output_o\ : std_logic;
SIGNAL \PWM_out_TP~output_o\ : std_logic;
SIGNAL \OSC_CLK_in~input_o\ : std_logic;
SIGNAL \OSC_CLK_in~inputclkctrl_outclk\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[0]~5_combout\ : std_logic;
SIGNAL \CD_L~input_o\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[2]~10\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[3]~11_combout\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[3]~12\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[4]~13_combout\ : std_logic;
SIGNAL \Chip4|Chip1|Equal0~0_combout\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[0]~6\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[1]~7_combout\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[1]~8\ : std_logic;
SIGNAL \Chip4|Chip1|present_state[2]~9_combout\ : std_logic;
SIGNAL \Chip4|Chip1|Equal0~1_combout\ : std_logic;
SIGNAL \Chip4|Chip2|current_state~0_combout\ : std_logic;
SIGNAL \Chip4|Chip2|current_state~feeder_combout\ : std_logic;
SIGNAL \Chip4|Chip2|current_state~q\ : std_logic;
SIGNAL \Chip4|Chip2|current_state~clkctrl_outclk\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[0]~13_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[6]~26\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[7]~27_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[7]~28\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[8]~29_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[8]~30\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[9]~31_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[9]~32\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[10]~33_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[10]~34\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[11]~35_combout\ : std_logic;
SIGNAL \Chip4|Chip3|TC5000~2_combout\ : std_logic;
SIGNAL \Chip4|Chip3|LessThan0~0_combout\ : std_logic;
SIGNAL \Chip4|Chip3|TC5000~3_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[11]~36\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[12]~37_combout\ : std_logic;
SIGNAL \Chip4|Chip3|LessThan0~1_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[0]~14\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[1]~15_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[1]~16\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[2]~17_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[2]~18\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[3]~19_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[3]~20\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[4]~21_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[4]~22\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[5]~23_combout\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[5]~24\ : std_logic;
SIGNAL \Chip4|Chip3|present_state[6]~25_combout\ : std_logic;
SIGNAL \Chip4|Chip3|TC5000~0_combout\ : std_logic;
SIGNAL \Chip4|Chip3|TC5000~1_combout\ : std_logic;
SIGNAL \Chip4|Chip3|TC5000~4_combout\ : std_logic;
SIGNAL \Chip4|Chip4|current_state~0_combout\ : std_logic;
SIGNAL \Chip4|Chip4|current_state~feeder_combout\ : std_logic;
SIGNAL \Chip4|Chip4|current_state~q\ : std_logic;
SIGNAL \Chip4|Chip4|current_state~clkctrl_outclk\ : std_logic;
SIGNAL \ST_L~input_o\ : std_logic;
SIGNAL \Chip2|next_state.One_high~0_combout\ : std_logic;
SIGNAL \Chip2|current_state.One_high~q\ : std_logic;
SIGNAL \Chip2|Selector0~0_combout\ : std_logic;
SIGNAL \Chip2|current_state.Key_presed~q\ : std_logic;
SIGNAL \Chip2|next_state.Idle~0_combout\ : std_logic;
SIGNAL \Chip2|current_state.Idle~q\ : std_logic;
SIGNAL \Chip2|next_state.One_zero_detected~0_combout\ : std_logic;
SIGNAL \Chip2|current_state.One_zero_detected~q\ : std_logic;
SIGNAL \Chip2|next_state.Two_zeroes_detected~0_combout\ : std_logic;
SIGNAL \Chip2|current_state.Two_zeroes_detected~q\ : std_logic;
SIGNAL \Chip2|next_state.Three_zeroes_detected~0_combout\ : std_logic;
SIGNAL \Chip2|current_state.Three_zeroes_detected~q\ : std_logic;
SIGNAL \Chip3|Selector0~0_combout\ : std_logic;
SIGNAL \Chip3|current_state.Idle~q\ : std_logic;
SIGNAL \Chip3|next_state.Pulse_ON~0_combout\ : std_logic;
SIGNAL \Chip3|current_state.Pulse_ON~q\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[0]~10_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[0]~11\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[1]~13_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[1]~14\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[2]~15_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[2]~16\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[3]~17_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[3]~18\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[4]~19_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[4]~20\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[5]~21_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[5]~22\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[6]~23_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[6]~24\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[7]~25_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[7]~26\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[8]~27_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[8]~28\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[9]~29_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|LessThan0~0_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|LessThan0~1_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|LessThan0~2_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state[5]~12_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip3|present_state[9]~feeder_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip2|Chip9|EQ~2_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip2|Chip9|EQ~1_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip2|Chip9|EQ~0_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip2|Chip9|EQ~3_combout\ : std_logic;
SIGNAL \Chip1|Chip1|Selector3~0_combout\ : std_logic;
SIGNAL \PW[2]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip5|present_state[2]~feeder_combout\ : std_logic;
SIGNAL \PW[3]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip4|Chip9|EQ~4_combout\ : std_logic;
SIGNAL \PW[0]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip5|present_state[0]~feeder_combout\ : std_logic;
SIGNAL \PW[1]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip4|Chip9|EQ~0_combout\ : std_logic;
SIGNAL \PW[4]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip5|present_state[4]~feeder_combout\ : std_logic;
SIGNAL \PW[5]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip4|Chip9|EQ~3_combout\ : std_logic;
SIGNAL \PW[8]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip5|present_state[8]~feeder_combout\ : std_logic;
SIGNAL \PW[9]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip4|Chip9|EQ~1_combout\ : std_logic;
SIGNAL \PW[6]~input_o\ : std_logic;
SIGNAL \PW[7]~input_o\ : std_logic;
SIGNAL \Chip1|Chip2|Chip4|Chip7|EQ~0_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip4|Chip9|EQ~2_combout\ : std_logic;
SIGNAL \Chip1|Chip2|Chip4|Chip9|EQ~5_combout\ : std_logic;
SIGNAL \Chip1|Chip1|Selector3~1_combout\ : std_logic;
SIGNAL \Chip1|Chip1|current_state.Wave_OFF~q\ : std_logic;
SIGNAL \Chip1|Chip1|current_state.Idle~0_combout\ : std_logic;
SIGNAL \Chip1|Chip1|current_state.Idle~q\ : std_logic;
SIGNAL \Chip1|Chip1|Selector1~0_combout\ : std_logic;
SIGNAL \Chip1|Chip1|current_state.Load_regs~q\ : std_logic;
SIGNAL \Chip1|Chip1|Selector2~0_combout\ : std_logic;
SIGNAL \Chip1|Chip1|current_state.Wave_ON~q\ : std_logic;
SIGNAL \Chip1|Chip2|Chip1|present_state\ : std_logic_vector(9 DOWNTO 0);
SIGNAL \Chip4|Chip1|present_state\ : std_logic_vector(4 DOWNTO 0);
SIGNAL \Chip1|Chip2|Chip3|present_state\ : std_logic_vector(9 DOWNTO 0);
SIGNAL \Chip4|Chip3|present_state\ : std_logic_vector(12 DOWNTO 0);
SIGNAL \Chip1|Chip2|Chip5|present_state\ : std_logic_vector(9 DOWNTO 0);
SIGNAL \Chip1|Chip1|ALT_INV_current_state.Wave_ON~q\ : std_logic;

COMPONENT hard_block
    PORT (
	devoe : IN std_logic;
	devclrn : IN std_logic;
	devpor : IN std_logic);
END COMPONENT;

BEGIN

ww_OSC_CLK_in <= OSC_CLK_in;
ww_CD_L <= CD_L;
ww_PW <= PW;
ww_ST_L <= ST_L;
PWM_out <= ww_PWM_out;
PWM_out_L <= ww_PWM_out_L;
LED_L <= ww_LED_L;
PWM_out_TP <= ww_PWM_out_TP;
ww_devoe <= devoe;
ww_devclrn <= devclrn;
ww_devpor <= devpor;

\~QUARTUS_CREATED_ADC1~_CHSEL_bus\ <= (\~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\);

\~QUARTUS_CREATED_ADC2~_CHSEL_bus\ <= (\~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\);

\Chip4|Chip4|current_state~clkctrl_INCLK_bus\ <= (vcc & vcc & vcc & \Chip4|Chip4|current_state~q\);

\Chip4|Chip2|current_state~clkctrl_INCLK_bus\ <= (vcc & vcc & vcc & \Chip4|Chip2|current_state~q\);

\OSC_CLK_in~inputclkctrl_INCLK_bus\ <= (vcc & vcc & vcc & \OSC_CLK_in~input_o\);
\Chip1|Chip1|ALT_INV_current_state.Wave_ON~q\ <= NOT \Chip1|Chip1|current_state.Wave_ON~q\;
auto_generated_inst : hard_block
PORT MAP (
	devoe => ww_devoe,
	devclrn => ww_devclrn,
	devpor => ww_devpor);

-- Location: LCCOMB_X44_Y41_N24
\~QUARTUS_CREATED_GND~I\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \~QUARTUS_CREATED_GND~I_combout\ = GND

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000000000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	combout => \~QUARTUS_CREATED_GND~I_combout\);

-- Location: IOOBUF_X49_Y54_N9
\PWM_out~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => \Chip1|Chip1|current_state.Wave_ON~q\,
	devoe => ww_devoe,
	o => \PWM_out~output_o\);

-- Location: IOOBUF_X46_Y54_N2
\PWM_out_L~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => \Chip1|Chip1|ALT_INV_current_state.Wave_ON~q\,
	devoe => ww_devoe,
	o => \PWM_out_L~output_o\);

-- Location: IOOBUF_X46_Y54_N23
\LED_L[1]~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => GND,
	devoe => ww_devoe,
	o => \LED_L[1]~output_o\);

-- Location: IOOBUF_X51_Y54_N16
\LED_L[2]~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => GND,
	devoe => ww_devoe,
	o => \LED_L[2]~output_o\);

-- Location: IOOBUF_X46_Y54_N9
\LED_L[3]~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => GND,
	devoe => ww_devoe,
	o => \LED_L[3]~output_o\);

-- Location: IOOBUF_X56_Y54_N30
\LED_L[4]~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => GND,
	devoe => ww_devoe,
	o => \LED_L[4]~output_o\);

-- Location: IOOBUF_X58_Y54_N23
\LED_L[5]~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => GND,
	devoe => ww_devoe,
	o => \LED_L[5]~output_o\);

-- Location: IOOBUF_X66_Y54_N23
\LED_L[6]~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => GND,
	devoe => ww_devoe,
	o => \LED_L[6]~output_o\);

-- Location: IOOBUF_X56_Y54_N9
\LED_L[7]~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => GND,
	devoe => ww_devoe,
	o => \LED_L[7]~output_o\);

-- Location: IOOBUF_X51_Y54_N9
\LED_L[8]~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => GND,
	devoe => ww_devoe,
	o => \LED_L[8]~output_o\);

-- Location: IOOBUF_X46_Y54_N16
\PWM_out_TP~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => \Chip1|Chip1|current_state.Wave_ON~q\,
	devoe => ww_devoe,
	o => \PWM_out_TP~output_o\);

-- Location: IOIBUF_X78_Y29_N22
\OSC_CLK_in~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_OSC_CLK_in,
	o => \OSC_CLK_in~input_o\);

-- Location: CLKCTRL_G9
\OSC_CLK_in~inputclkctrl\ : fiftyfivenm_clkctrl
-- pragma translate_off
GENERIC MAP (
	clock_type => "global clock",
	ena_register_mode => "none")
-- pragma translate_on
PORT MAP (
	inclk => \OSC_CLK_in~inputclkctrl_INCLK_bus\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	outclk => \OSC_CLK_in~inputclkctrl_outclk\);

-- Location: LCCOMB_X45_Y52_N6
\Chip4|Chip1|present_state[0]~5\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip1|present_state[0]~5_combout\ = \Chip4|Chip1|present_state\(0) $ (VCC)
-- \Chip4|Chip1|present_state[0]~6\ = CARRY(\Chip4|Chip1|present_state\(0))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101010110101010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip1|present_state\(0),
	datad => VCC,
	combout => \Chip4|Chip1|present_state[0]~5_combout\,
	cout => \Chip4|Chip1|present_state[0]~6\);

-- Location: IOIBUF_X46_Y54_N29
\CD_L~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_CD_L,
	o => \CD_L~input_o\);

-- Location: LCCOMB_X45_Y52_N10
\Chip4|Chip1|present_state[2]~9\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip1|present_state[2]~9_combout\ = (\Chip4|Chip1|present_state\(2) & (\Chip4|Chip1|present_state[1]~8\ $ (GND))) # (!\Chip4|Chip1|present_state\(2) & (!\Chip4|Chip1|present_state[1]~8\ & VCC))
-- \Chip4|Chip1|present_state[2]~10\ = CARRY((\Chip4|Chip1|present_state\(2) & !\Chip4|Chip1|present_state[1]~8\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1010010100001010",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip1|present_state\(2),
	datad => VCC,
	cin => \Chip4|Chip1|present_state[1]~8\,
	combout => \Chip4|Chip1|present_state[2]~9_combout\,
	cout => \Chip4|Chip1|present_state[2]~10\);

-- Location: LCCOMB_X45_Y52_N12
\Chip4|Chip1|present_state[3]~11\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip1|present_state[3]~11_combout\ = (\Chip4|Chip1|present_state\(3) & (!\Chip4|Chip1|present_state[2]~10\)) # (!\Chip4|Chip1|present_state\(3) & ((\Chip4|Chip1|present_state[2]~10\) # (GND)))
-- \Chip4|Chip1|present_state[3]~12\ = CARRY((!\Chip4|Chip1|present_state[2]~10\) # (!\Chip4|Chip1|present_state\(3)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101101001011111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip1|present_state\(3),
	datad => VCC,
	cin => \Chip4|Chip1|present_state[2]~10\,
	combout => \Chip4|Chip1|present_state[3]~11_combout\,
	cout => \Chip4|Chip1|present_state[3]~12\);

-- Location: FF_X45_Y52_N13
\Chip4|Chip1|present_state[3]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip1|present_state[3]~11_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip1|Equal0~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip1|present_state\(3));

-- Location: LCCOMB_X45_Y52_N14
\Chip4|Chip1|present_state[4]~13\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip1|present_state[4]~13_combout\ = \Chip4|Chip1|present_state\(4) $ (!\Chip4|Chip1|present_state[3]~12\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001111000011",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip1|present_state\(4),
	cin => \Chip4|Chip1|present_state[3]~12\,
	combout => \Chip4|Chip1|present_state[4]~13_combout\);

-- Location: FF_X45_Y52_N15
\Chip4|Chip1|present_state[4]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip1|present_state[4]~13_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip1|Equal0~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip1|present_state\(4));

-- Location: LCCOMB_X45_Y52_N2
\Chip4|Chip1|Equal0~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip1|Equal0~0_combout\ = (\Chip4|Chip1|present_state\(4) & \Chip4|Chip1|present_state\(3))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111000000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip4|Chip1|present_state\(4),
	datad => \Chip4|Chip1|present_state\(3),
	combout => \Chip4|Chip1|Equal0~0_combout\);

-- Location: FF_X45_Y52_N7
\Chip4|Chip1|present_state[0]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip1|present_state[0]~5_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip1|Equal0~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip1|present_state\(0));

-- Location: LCCOMB_X45_Y52_N8
\Chip4|Chip1|present_state[1]~7\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip1|present_state[1]~7_combout\ = (\Chip4|Chip1|present_state\(1) & (!\Chip4|Chip1|present_state[0]~6\)) # (!\Chip4|Chip1|present_state\(1) & ((\Chip4|Chip1|present_state[0]~6\) # (GND)))
-- \Chip4|Chip1|present_state[1]~8\ = CARRY((!\Chip4|Chip1|present_state[0]~6\) # (!\Chip4|Chip1|present_state\(1)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011110000111111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip1|present_state\(1),
	datad => VCC,
	cin => \Chip4|Chip1|present_state[0]~6\,
	combout => \Chip4|Chip1|present_state[1]~7_combout\,
	cout => \Chip4|Chip1|present_state[1]~8\);

-- Location: FF_X45_Y52_N9
\Chip4|Chip1|present_state[1]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip1|present_state[1]~7_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip1|Equal0~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip1|present_state\(1));

-- Location: FF_X45_Y52_N11
\Chip4|Chip1|present_state[2]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip1|present_state[2]~9_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip1|Equal0~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip1|present_state\(2));

-- Location: LCCOMB_X45_Y52_N18
\Chip4|Chip1|Equal0~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip1|Equal0~1_combout\ = (!\Chip4|Chip1|present_state\(2) & (!\Chip4|Chip1|present_state\(0) & (!\Chip4|Chip1|present_state\(1) & \Chip4|Chip1|Equal0~0_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000000100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip1|present_state\(2),
	datab => \Chip4|Chip1|present_state\(0),
	datac => \Chip4|Chip1|present_state\(1),
	datad => \Chip4|Chip1|Equal0~0_combout\,
	combout => \Chip4|Chip1|Equal0~1_combout\);

-- Location: LCCOMB_X45_Y52_N24
\Chip4|Chip2|current_state~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip2|current_state~0_combout\ = \Chip4|Chip2|current_state~q\ $ (\Chip4|Chip1|Equal0~1_combout\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101010110101010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip2|current_state~q\,
	datad => \Chip4|Chip1|Equal0~1_combout\,
	combout => \Chip4|Chip2|current_state~0_combout\);

-- Location: LCCOMB_X45_Y52_N28
\Chip4|Chip2|current_state~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip2|current_state~feeder_combout\ = \Chip4|Chip2|current_state~0_combout\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \Chip4|Chip2|current_state~0_combout\,
	combout => \Chip4|Chip2|current_state~feeder_combout\);

-- Location: FF_X45_Y52_N29
\Chip4|Chip2|current_state\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip2|current_state~feeder_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip2|current_state~q\);

-- Location: CLKCTRL_G10
\Chip4|Chip2|current_state~clkctrl\ : fiftyfivenm_clkctrl
-- pragma translate_off
GENERIC MAP (
	clock_type => "global clock",
	ena_register_mode => "none")
-- pragma translate_on
PORT MAP (
	inclk => \Chip4|Chip2|current_state~clkctrl_INCLK_bus\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	outclk => \Chip4|Chip2|current_state~clkctrl_outclk\);

-- Location: LCCOMB_X46_Y52_N4
\Chip4|Chip3|present_state[0]~13\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[0]~13_combout\ = \Chip4|Chip3|present_state\(0) $ (VCC)
-- \Chip4|Chip3|present_state[0]~14\ = CARRY(\Chip4|Chip3|present_state\(0))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011001111001100",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(0),
	datad => VCC,
	combout => \Chip4|Chip3|present_state[0]~13_combout\,
	cout => \Chip4|Chip3|present_state[0]~14\);

-- Location: LCCOMB_X46_Y52_N16
\Chip4|Chip3|present_state[6]~25\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[6]~25_combout\ = (\Chip4|Chip3|present_state\(6) & (\Chip4|Chip3|present_state[5]~24\ $ (GND))) # (!\Chip4|Chip3|present_state\(6) & (!\Chip4|Chip3|present_state[5]~24\ & VCC))
-- \Chip4|Chip3|present_state[6]~26\ = CARRY((\Chip4|Chip3|present_state\(6) & !\Chip4|Chip3|present_state[5]~24\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(6),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[5]~24\,
	combout => \Chip4|Chip3|present_state[6]~25_combout\,
	cout => \Chip4|Chip3|present_state[6]~26\);

-- Location: LCCOMB_X46_Y52_N18
\Chip4|Chip3|present_state[7]~27\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[7]~27_combout\ = (\Chip4|Chip3|present_state\(7) & (!\Chip4|Chip3|present_state[6]~26\)) # (!\Chip4|Chip3|present_state\(7) & ((\Chip4|Chip3|present_state[6]~26\) # (GND)))
-- \Chip4|Chip3|present_state[7]~28\ = CARRY((!\Chip4|Chip3|present_state[6]~26\) # (!\Chip4|Chip3|present_state\(7)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011110000111111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(7),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[6]~26\,
	combout => \Chip4|Chip3|present_state[7]~27_combout\,
	cout => \Chip4|Chip3|present_state[7]~28\);

-- Location: FF_X46_Y52_N19
\Chip4|Chip3|present_state[7]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[7]~27_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(7));

-- Location: LCCOMB_X46_Y52_N20
\Chip4|Chip3|present_state[8]~29\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[8]~29_combout\ = (\Chip4|Chip3|present_state\(8) & (\Chip4|Chip3|present_state[7]~28\ $ (GND))) # (!\Chip4|Chip3|present_state\(8) & (!\Chip4|Chip3|present_state[7]~28\ & VCC))
-- \Chip4|Chip3|present_state[8]~30\ = CARRY((\Chip4|Chip3|present_state\(8) & !\Chip4|Chip3|present_state[7]~28\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(8),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[7]~28\,
	combout => \Chip4|Chip3|present_state[8]~29_combout\,
	cout => \Chip4|Chip3|present_state[8]~30\);

-- Location: FF_X46_Y52_N21
\Chip4|Chip3|present_state[8]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[8]~29_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(8));

-- Location: LCCOMB_X46_Y52_N22
\Chip4|Chip3|present_state[9]~31\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[9]~31_combout\ = (\Chip4|Chip3|present_state\(9) & (!\Chip4|Chip3|present_state[8]~30\)) # (!\Chip4|Chip3|present_state\(9) & ((\Chip4|Chip3|present_state[8]~30\) # (GND)))
-- \Chip4|Chip3|present_state[9]~32\ = CARRY((!\Chip4|Chip3|present_state[8]~30\) # (!\Chip4|Chip3|present_state\(9)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101101001011111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|present_state\(9),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[8]~30\,
	combout => \Chip4|Chip3|present_state[9]~31_combout\,
	cout => \Chip4|Chip3|present_state[9]~32\);

-- Location: FF_X46_Y52_N23
\Chip4|Chip3|present_state[9]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[9]~31_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(9));

-- Location: LCCOMB_X46_Y52_N24
\Chip4|Chip3|present_state[10]~33\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[10]~33_combout\ = (\Chip4|Chip3|present_state\(10) & (\Chip4|Chip3|present_state[9]~32\ $ (GND))) # (!\Chip4|Chip3|present_state\(10) & (!\Chip4|Chip3|present_state[9]~32\ & VCC))
-- \Chip4|Chip3|present_state[10]~34\ = CARRY((\Chip4|Chip3|present_state\(10) & !\Chip4|Chip3|present_state[9]~32\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(10),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[9]~32\,
	combout => \Chip4|Chip3|present_state[10]~33_combout\,
	cout => \Chip4|Chip3|present_state[10]~34\);

-- Location: FF_X46_Y52_N25
\Chip4|Chip3|present_state[10]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[10]~33_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(10));

-- Location: LCCOMB_X46_Y52_N26
\Chip4|Chip3|present_state[11]~35\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[11]~35_combout\ = (\Chip4|Chip3|present_state\(11) & (!\Chip4|Chip3|present_state[10]~34\)) # (!\Chip4|Chip3|present_state\(11) & ((\Chip4|Chip3|present_state[10]~34\) # (GND)))
-- \Chip4|Chip3|present_state[11]~36\ = CARRY((!\Chip4|Chip3|present_state[10]~34\) # (!\Chip4|Chip3|present_state\(11)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101101001011111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|present_state\(11),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[10]~34\,
	combout => \Chip4|Chip3|present_state[11]~35_combout\,
	cout => \Chip4|Chip3|present_state[11]~36\);

-- Location: FF_X46_Y52_N27
\Chip4|Chip3|present_state[11]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[11]~35_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(11));

-- Location: LCCOMB_X46_Y52_N0
\Chip4|Chip3|TC5000~2\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|TC5000~2_combout\ = (\Chip4|Chip3|present_state\(8) & (\Chip4|Chip3|present_state\(9) & \Chip4|Chip3|present_state\(7)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100000000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(8),
	datac => \Chip4|Chip3|present_state\(9),
	datad => \Chip4|Chip3|present_state\(7),
	combout => \Chip4|Chip3|TC5000~2_combout\);

-- Location: LCCOMB_X46_Y52_N30
\Chip4|Chip3|LessThan0~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|LessThan0~0_combout\ = (!\Chip4|Chip3|present_state\(10) & (!\Chip4|Chip3|present_state\(11) & !\Chip4|Chip3|TC5000~2_combout\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000000000000011",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(10),
	datac => \Chip4|Chip3|present_state\(11),
	datad => \Chip4|Chip3|TC5000~2_combout\,
	combout => \Chip4|Chip3|LessThan0~0_combout\);

-- Location: LCCOMB_X45_Y52_N30
\Chip4|Chip3|TC5000~3\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|TC5000~3_combout\ = (\Chip4|Chip3|present_state\(1) & (\Chip4|Chip3|present_state\(2) & \Chip4|Chip3|present_state\(0)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1010000000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|present_state\(1),
	datac => \Chip4|Chip3|present_state\(2),
	datad => \Chip4|Chip3|present_state\(0),
	combout => \Chip4|Chip3|TC5000~3_combout\);

-- Location: LCCOMB_X46_Y52_N28
\Chip4|Chip3|present_state[12]~37\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[12]~37_combout\ = \Chip4|Chip3|present_state[11]~36\ $ (!\Chip4|Chip3|present_state\(12))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111000000001111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datad => \Chip4|Chip3|present_state\(12),
	cin => \Chip4|Chip3|present_state[11]~36\,
	combout => \Chip4|Chip3|present_state[12]~37_combout\);

-- Location: FF_X46_Y52_N29
\Chip4|Chip3|present_state[12]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[12]~37_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(12));

-- Location: LCCOMB_X46_Y52_N2
\Chip4|Chip3|LessThan0~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|LessThan0~1_combout\ = (!\Chip4|Chip3|LessThan0~0_combout\ & (\Chip4|Chip3|present_state\(12) & ((\Chip4|Chip3|TC5000~3_combout\) # (!\Chip4|Chip3|TC5000~1_combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0100010100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|LessThan0~0_combout\,
	datab => \Chip4|Chip3|TC5000~3_combout\,
	datac => \Chip4|Chip3|TC5000~1_combout\,
	datad => \Chip4|Chip3|present_state\(12),
	combout => \Chip4|Chip3|LessThan0~1_combout\);

-- Location: FF_X46_Y52_N5
\Chip4|Chip3|present_state[0]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[0]~13_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(0));

-- Location: LCCOMB_X46_Y52_N6
\Chip4|Chip3|present_state[1]~15\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[1]~15_combout\ = (\Chip4|Chip3|present_state\(1) & (!\Chip4|Chip3|present_state[0]~14\)) # (!\Chip4|Chip3|present_state\(1) & ((\Chip4|Chip3|present_state[0]~14\) # (GND)))
-- \Chip4|Chip3|present_state[1]~16\ = CARRY((!\Chip4|Chip3|present_state[0]~14\) # (!\Chip4|Chip3|present_state\(1)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101101001011111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|present_state\(1),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[0]~14\,
	combout => \Chip4|Chip3|present_state[1]~15_combout\,
	cout => \Chip4|Chip3|present_state[1]~16\);

-- Location: FF_X46_Y52_N7
\Chip4|Chip3|present_state[1]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[1]~15_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(1));

-- Location: LCCOMB_X46_Y52_N8
\Chip4|Chip3|present_state[2]~17\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[2]~17_combout\ = (\Chip4|Chip3|present_state\(2) & (\Chip4|Chip3|present_state[1]~16\ $ (GND))) # (!\Chip4|Chip3|present_state\(2) & (!\Chip4|Chip3|present_state[1]~16\ & VCC))
-- \Chip4|Chip3|present_state[2]~18\ = CARRY((\Chip4|Chip3|present_state\(2) & !\Chip4|Chip3|present_state[1]~16\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(2),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[1]~16\,
	combout => \Chip4|Chip3|present_state[2]~17_combout\,
	cout => \Chip4|Chip3|present_state[2]~18\);

-- Location: FF_X46_Y52_N9
\Chip4|Chip3|present_state[2]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[2]~17_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(2));

-- Location: LCCOMB_X46_Y52_N10
\Chip4|Chip3|present_state[3]~19\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[3]~19_combout\ = (\Chip4|Chip3|present_state\(3) & (!\Chip4|Chip3|present_state[2]~18\)) # (!\Chip4|Chip3|present_state\(3) & ((\Chip4|Chip3|present_state[2]~18\) # (GND)))
-- \Chip4|Chip3|present_state[3]~20\ = CARRY((!\Chip4|Chip3|present_state[2]~18\) # (!\Chip4|Chip3|present_state\(3)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101101001011111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|present_state\(3),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[2]~18\,
	combout => \Chip4|Chip3|present_state[3]~19_combout\,
	cout => \Chip4|Chip3|present_state[3]~20\);

-- Location: FF_X46_Y52_N11
\Chip4|Chip3|present_state[3]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[3]~19_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(3));

-- Location: LCCOMB_X46_Y52_N12
\Chip4|Chip3|present_state[4]~21\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[4]~21_combout\ = (\Chip4|Chip3|present_state\(4) & (\Chip4|Chip3|present_state[3]~20\ $ (GND))) # (!\Chip4|Chip3|present_state\(4) & (!\Chip4|Chip3|present_state[3]~20\ & VCC))
-- \Chip4|Chip3|present_state[4]~22\ = CARRY((\Chip4|Chip3|present_state\(4) & !\Chip4|Chip3|present_state[3]~20\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1010010100001010",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|present_state\(4),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[3]~20\,
	combout => \Chip4|Chip3|present_state[4]~21_combout\,
	cout => \Chip4|Chip3|present_state[4]~22\);

-- Location: FF_X46_Y52_N13
\Chip4|Chip3|present_state[4]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[4]~21_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(4));

-- Location: LCCOMB_X46_Y52_N14
\Chip4|Chip3|present_state[5]~23\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|present_state[5]~23_combout\ = (\Chip4|Chip3|present_state\(5) & (!\Chip4|Chip3|present_state[4]~22\)) # (!\Chip4|Chip3|present_state\(5) & ((\Chip4|Chip3|present_state[4]~22\) # (GND)))
-- \Chip4|Chip3|present_state[5]~24\ = CARRY((!\Chip4|Chip3|present_state[4]~22\) # (!\Chip4|Chip3|present_state\(5)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011110000111111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(5),
	datad => VCC,
	cin => \Chip4|Chip3|present_state[4]~22\,
	combout => \Chip4|Chip3|present_state[5]~23_combout\,
	cout => \Chip4|Chip3|present_state[5]~24\);

-- Location: FF_X46_Y52_N15
\Chip4|Chip3|present_state[5]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[5]~23_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(5));

-- Location: FF_X46_Y52_N17
\Chip4|Chip3|present_state[6]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip3|present_state[6]~25_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip4|Chip3|LessThan0~1_combout\,
	ena => \Chip4|Chip1|Equal0~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip3|present_state\(6));

-- Location: LCCOMB_X45_Y52_N16
\Chip4|Chip3|TC5000~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|TC5000~0_combout\ = (!\Chip4|Chip3|present_state\(11) & (!\Chip4|Chip3|present_state\(3) & (!\Chip4|Chip3|present_state\(4) & !\Chip4|Chip3|present_state\(10))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000000000000001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|present_state\(11),
	datab => \Chip4|Chip3|present_state\(3),
	datac => \Chip4|Chip3|present_state\(4),
	datad => \Chip4|Chip3|present_state\(10),
	combout => \Chip4|Chip3|TC5000~0_combout\);

-- Location: LCCOMB_X45_Y52_N26
\Chip4|Chip3|TC5000~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|TC5000~1_combout\ = (!\Chip4|Chip3|present_state\(6) & (!\Chip4|Chip3|present_state\(5) & \Chip4|Chip3|TC5000~0_combout\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000001100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datab => \Chip4|Chip3|present_state\(6),
	datac => \Chip4|Chip3|present_state\(5),
	datad => \Chip4|Chip3|TC5000~0_combout\,
	combout => \Chip4|Chip3|TC5000~1_combout\);

-- Location: LCCOMB_X45_Y52_N22
\Chip4|Chip3|TC5000~4\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip3|TC5000~4_combout\ = (\Chip4|Chip3|TC5000~3_combout\ & (\Chip4|Chip3|present_state\(12) & \Chip4|Chip3|TC5000~2_combout\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1000000010000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|TC5000~3_combout\,
	datab => \Chip4|Chip3|present_state\(12),
	datac => \Chip4|Chip3|TC5000~2_combout\,
	combout => \Chip4|Chip3|TC5000~4_combout\);

-- Location: LCCOMB_X45_Y52_N20
\Chip4|Chip4|current_state~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip4|current_state~0_combout\ = \Chip4|Chip4|current_state~q\ $ (((\Chip4|Chip3|TC5000~1_combout\ & (\Chip4|Chip1|Equal0~1_combout\ & \Chip4|Chip3|TC5000~4_combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0111111110000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip3|TC5000~1_combout\,
	datab => \Chip4|Chip1|Equal0~1_combout\,
	datac => \Chip4|Chip3|TC5000~4_combout\,
	datad => \Chip4|Chip4|current_state~q\,
	combout => \Chip4|Chip4|current_state~0_combout\);

-- Location: LCCOMB_X45_Y52_N4
\Chip4|Chip4|current_state~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip4|Chip4|current_state~feeder_combout\ = \Chip4|Chip4|current_state~0_combout\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1010101010101010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip4|Chip4|current_state~0_combout\,
	combout => \Chip4|Chip4|current_state~feeder_combout\);

-- Location: FF_X45_Y52_N5
\Chip4|Chip4|current_state\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \OSC_CLK_in~inputclkctrl_outclk\,
	d => \Chip4|Chip4|current_state~feeder_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip4|Chip4|current_state~q\);

-- Location: CLKCTRL_G12
\Chip4|Chip4|current_state~clkctrl\ : fiftyfivenm_clkctrl
-- pragma translate_off
GENERIC MAP (
	clock_type => "global clock",
	ena_register_mode => "none")
-- pragma translate_on
PORT MAP (
	inclk => \Chip4|Chip4|current_state~clkctrl_INCLK_bus\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	outclk => \Chip4|Chip4|current_state~clkctrl_outclk\);

-- Location: IOIBUF_X49_Y54_N29
\ST_L~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_ST_L,
	o => \ST_L~input_o\);

-- Location: LCCOMB_X56_Y51_N28
\Chip2|next_state.One_high~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|next_state.One_high~0_combout\ = (\ST_L~input_o\ & \Chip2|current_state.Key_presed~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100000011000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datab => \ST_L~input_o\,
	datac => \Chip2|current_state.Key_presed~q\,
	combout => \Chip2|next_state.One_high~0_combout\);

-- Location: FF_X56_Y51_N29
\Chip2|current_state.One_high\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip4|current_state~clkctrl_outclk\,
	d => \Chip2|next_state.One_high~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|current_state.One_high~q\);

-- Location: LCCOMB_X56_Y51_N26
\Chip2|Selector0~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Selector0~0_combout\ = (\Chip2|current_state.Three_zeroes_detected~q\) # ((!\ST_L~input_o\ & ((\Chip2|current_state.Key_presed~q\) # (\Chip2|current_state.One_high~q\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1011101110111010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|current_state.Three_zeroes_detected~q\,
	datab => \ST_L~input_o\,
	datac => \Chip2|current_state.Key_presed~q\,
	datad => \Chip2|current_state.One_high~q\,
	combout => \Chip2|Selector0~0_combout\);

-- Location: FF_X56_Y51_N27
\Chip2|current_state.Key_presed\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip4|current_state~clkctrl_outclk\,
	d => \Chip2|Selector0~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|current_state.Key_presed~q\);

-- Location: LCCOMB_X56_Y51_N16
\Chip2|next_state.Idle~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|next_state.Idle~0_combout\ = ((\Chip2|current_state.Key_presed~q\) # (\Chip2|current_state.Three_zeroes_detected~q\)) # (!\ST_L~input_o\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111111110011",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datab => \ST_L~input_o\,
	datac => \Chip2|current_state.Key_presed~q\,
	datad => \Chip2|current_state.Three_zeroes_detected~q\,
	combout => \Chip2|next_state.Idle~0_combout\);

-- Location: FF_X56_Y51_N17
\Chip2|current_state.Idle\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip4|current_state~clkctrl_outclk\,
	d => \Chip2|next_state.Idle~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|current_state.Idle~q\);

-- Location: LCCOMB_X56_Y51_N2
\Chip2|next_state.One_zero_detected~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|next_state.One_zero_detected~0_combout\ = (!\ST_L~input_o\ & !\Chip2|current_state.Idle~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000000000001111",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \ST_L~input_o\,
	datad => \Chip2|current_state.Idle~q\,
	combout => \Chip2|next_state.One_zero_detected~0_combout\);

-- Location: FF_X56_Y51_N3
\Chip2|current_state.One_zero_detected\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip4|current_state~clkctrl_outclk\,
	d => \Chip2|next_state.One_zero_detected~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|current_state.One_zero_detected~q\);

-- Location: LCCOMB_X56_Y51_N0
\Chip2|next_state.Two_zeroes_detected~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|next_state.Two_zeroes_detected~0_combout\ = (!\ST_L~input_o\ & \Chip2|current_state.One_zero_detected~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \ST_L~input_o\,
	datad => \Chip2|current_state.One_zero_detected~q\,
	combout => \Chip2|next_state.Two_zeroes_detected~0_combout\);

-- Location: FF_X56_Y51_N1
\Chip2|current_state.Two_zeroes_detected\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip4|current_state~clkctrl_outclk\,
	d => \Chip2|next_state.Two_zeroes_detected~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|current_state.Two_zeroes_detected~q\);

-- Location: LCCOMB_X56_Y51_N6
\Chip2|next_state.Three_zeroes_detected~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|next_state.Three_zeroes_detected~0_combout\ = (!\ST_L~input_o\ & \Chip2|current_state.Two_zeroes_detected~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \ST_L~input_o\,
	datad => \Chip2|current_state.Two_zeroes_detected~q\,
	combout => \Chip2|next_state.Three_zeroes_detected~0_combout\);

-- Location: FF_X56_Y51_N7
\Chip2|current_state.Three_zeroes_detected\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip4|current_state~clkctrl_outclk\,
	d => \Chip2|next_state.Three_zeroes_detected~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|current_state.Three_zeroes_detected~q\);

-- Location: LCCOMB_X56_Y51_N12
\Chip3|Selector0~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip3|Selector0~0_combout\ = (\Chip2|current_state.Three_zeroes_detected~q\) # (\Chip3|current_state.Pulse_ON~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111111110000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip2|current_state.Three_zeroes_detected~q\,
	datad => \Chip3|current_state.Pulse_ON~q\,
	combout => \Chip3|Selector0~0_combout\);

-- Location: FF_X56_Y51_N13
\Chip3|current_state.Idle\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip3|Selector0~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip3|current_state.Idle~q\);

-- Location: LCCOMB_X56_Y51_N14
\Chip3|next_state.Pulse_ON~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip3|next_state.Pulse_ON~0_combout\ = (\Chip2|current_state.Three_zeroes_detected~q\ & !\Chip3|current_state.Idle~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000101000001010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|current_state.Three_zeroes_detected~q\,
	datac => \Chip3|current_state.Idle~q\,
	combout => \Chip3|next_state.Pulse_ON~0_combout\);

-- Location: FF_X56_Y51_N15
\Chip3|current_state.Pulse_ON\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip3|next_state.Pulse_ON~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip3|current_state.Pulse_ON~q\);

-- Location: LCCOMB_X55_Y51_N0
\Chip1|Chip2|Chip1|present_state[0]~10\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[0]~10_combout\ = \Chip1|Chip2|Chip1|present_state\(0) $ (VCC)
-- \Chip1|Chip2|Chip1|present_state[0]~11\ = CARRY(\Chip1|Chip2|Chip1|present_state\(0))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011001111001100",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datab => \Chip1|Chip2|Chip1|present_state\(0),
	datad => VCC,
	combout => \Chip1|Chip2|Chip1|present_state[0]~10_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[0]~11\);

-- Location: LCCOMB_X55_Y51_N2
\Chip1|Chip2|Chip1|present_state[1]~13\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[1]~13_combout\ = (\Chip1|Chip2|Chip1|present_state\(1) & (!\Chip1|Chip2|Chip1|present_state[0]~11\)) # (!\Chip1|Chip2|Chip1|present_state\(1) & ((\Chip1|Chip2|Chip1|present_state[0]~11\) # (GND)))
-- \Chip1|Chip2|Chip1|present_state[1]~14\ = CARRY((!\Chip1|Chip2|Chip1|present_state[0]~11\) # (!\Chip1|Chip2|Chip1|present_state\(1)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011110000111111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip1|Chip2|Chip1|present_state\(1),
	datad => VCC,
	cin => \Chip1|Chip2|Chip1|present_state[0]~11\,
	combout => \Chip1|Chip2|Chip1|present_state[1]~13_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[1]~14\);

-- Location: FF_X55_Y51_N3
\Chip1|Chip2|Chip1|present_state[1]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[1]~13_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(1));

-- Location: LCCOMB_X55_Y51_N4
\Chip1|Chip2|Chip1|present_state[2]~15\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[2]~15_combout\ = (\Chip1|Chip2|Chip1|present_state\(2) & (\Chip1|Chip2|Chip1|present_state[1]~14\ $ (GND))) # (!\Chip1|Chip2|Chip1|present_state\(2) & (!\Chip1|Chip2|Chip1|present_state[1]~14\ & VCC))
-- \Chip1|Chip2|Chip1|present_state[2]~16\ = CARRY((\Chip1|Chip2|Chip1|present_state\(2) & !\Chip1|Chip2|Chip1|present_state[1]~14\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip1|Chip2|Chip1|present_state\(2),
	datad => VCC,
	cin => \Chip1|Chip2|Chip1|present_state[1]~14\,
	combout => \Chip1|Chip2|Chip1|present_state[2]~15_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[2]~16\);

-- Location: FF_X55_Y51_N5
\Chip1|Chip2|Chip1|present_state[2]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[2]~15_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(2));

-- Location: LCCOMB_X55_Y51_N6
\Chip1|Chip2|Chip1|present_state[3]~17\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[3]~17_combout\ = (\Chip1|Chip2|Chip1|present_state\(3) & (!\Chip1|Chip2|Chip1|present_state[2]~16\)) # (!\Chip1|Chip2|Chip1|present_state\(3) & ((\Chip1|Chip2|Chip1|present_state[2]~16\) # (GND)))
-- \Chip1|Chip2|Chip1|present_state[3]~18\ = CARRY((!\Chip1|Chip2|Chip1|present_state[2]~16\) # (!\Chip1|Chip2|Chip1|present_state\(3)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101101001011111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(3),
	datad => VCC,
	cin => \Chip1|Chip2|Chip1|present_state[2]~16\,
	combout => \Chip1|Chip2|Chip1|present_state[3]~17_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[3]~18\);

-- Location: FF_X55_Y51_N7
\Chip1|Chip2|Chip1|present_state[3]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[3]~17_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(3));

-- Location: LCCOMB_X55_Y51_N8
\Chip1|Chip2|Chip1|present_state[4]~19\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[4]~19_combout\ = (\Chip1|Chip2|Chip1|present_state\(4) & (\Chip1|Chip2|Chip1|present_state[3]~18\ $ (GND))) # (!\Chip1|Chip2|Chip1|present_state\(4) & (!\Chip1|Chip2|Chip1|present_state[3]~18\ & VCC))
-- \Chip1|Chip2|Chip1|present_state[4]~20\ = CARRY((\Chip1|Chip2|Chip1|present_state\(4) & !\Chip1|Chip2|Chip1|present_state[3]~18\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip1|Chip2|Chip1|present_state\(4),
	datad => VCC,
	cin => \Chip1|Chip2|Chip1|present_state[3]~18\,
	combout => \Chip1|Chip2|Chip1|present_state[4]~19_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[4]~20\);

-- Location: FF_X55_Y51_N9
\Chip1|Chip2|Chip1|present_state[4]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[4]~19_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(4));

-- Location: LCCOMB_X55_Y51_N10
\Chip1|Chip2|Chip1|present_state[5]~21\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[5]~21_combout\ = (\Chip1|Chip2|Chip1|present_state\(5) & (!\Chip1|Chip2|Chip1|present_state[4]~20\)) # (!\Chip1|Chip2|Chip1|present_state\(5) & ((\Chip1|Chip2|Chip1|present_state[4]~20\) # (GND)))
-- \Chip1|Chip2|Chip1|present_state[5]~22\ = CARRY((!\Chip1|Chip2|Chip1|present_state[4]~20\) # (!\Chip1|Chip2|Chip1|present_state\(5)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101101001011111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(5),
	datad => VCC,
	cin => \Chip1|Chip2|Chip1|present_state[4]~20\,
	combout => \Chip1|Chip2|Chip1|present_state[5]~21_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[5]~22\);

-- Location: FF_X55_Y51_N11
\Chip1|Chip2|Chip1|present_state[5]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[5]~21_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(5));

-- Location: LCCOMB_X55_Y51_N12
\Chip1|Chip2|Chip1|present_state[6]~23\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[6]~23_combout\ = (\Chip1|Chip2|Chip1|present_state\(6) & (\Chip1|Chip2|Chip1|present_state[5]~22\ $ (GND))) # (!\Chip1|Chip2|Chip1|present_state\(6) & (!\Chip1|Chip2|Chip1|present_state[5]~22\ & VCC))
-- \Chip1|Chip2|Chip1|present_state[6]~24\ = CARRY((\Chip1|Chip2|Chip1|present_state\(6) & !\Chip1|Chip2|Chip1|present_state[5]~22\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1010010100001010",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(6),
	datad => VCC,
	cin => \Chip1|Chip2|Chip1|present_state[5]~22\,
	combout => \Chip1|Chip2|Chip1|present_state[6]~23_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[6]~24\);

-- Location: FF_X55_Y51_N13
\Chip1|Chip2|Chip1|present_state[6]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[6]~23_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(6));

-- Location: LCCOMB_X55_Y51_N14
\Chip1|Chip2|Chip1|present_state[7]~25\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[7]~25_combout\ = (\Chip1|Chip2|Chip1|present_state\(7) & (!\Chip1|Chip2|Chip1|present_state[6]~24\)) # (!\Chip1|Chip2|Chip1|present_state\(7) & ((\Chip1|Chip2|Chip1|present_state[6]~24\) # (GND)))
-- \Chip1|Chip2|Chip1|present_state[7]~26\ = CARRY((!\Chip1|Chip2|Chip1|present_state[6]~24\) # (!\Chip1|Chip2|Chip1|present_state\(7)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011110000111111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip1|Chip2|Chip1|present_state\(7),
	datad => VCC,
	cin => \Chip1|Chip2|Chip1|present_state[6]~24\,
	combout => \Chip1|Chip2|Chip1|present_state[7]~25_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[7]~26\);

-- Location: FF_X55_Y51_N15
\Chip1|Chip2|Chip1|present_state[7]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[7]~25_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(7));

-- Location: LCCOMB_X55_Y51_N16
\Chip1|Chip2|Chip1|present_state[8]~27\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[8]~27_combout\ = (\Chip1|Chip2|Chip1|present_state\(8) & (\Chip1|Chip2|Chip1|present_state[7]~26\ $ (GND))) # (!\Chip1|Chip2|Chip1|present_state\(8) & (!\Chip1|Chip2|Chip1|present_state[7]~26\ & VCC))
-- \Chip1|Chip2|Chip1|present_state[8]~28\ = CARRY((\Chip1|Chip2|Chip1|present_state\(8) & !\Chip1|Chip2|Chip1|present_state[7]~26\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip1|Chip2|Chip1|present_state\(8),
	datad => VCC,
	cin => \Chip1|Chip2|Chip1|present_state[7]~26\,
	combout => \Chip1|Chip2|Chip1|present_state[8]~27_combout\,
	cout => \Chip1|Chip2|Chip1|present_state[8]~28\);

-- Location: FF_X55_Y51_N17
\Chip1|Chip2|Chip1|present_state[8]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[8]~27_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(8));

-- Location: LCCOMB_X55_Y51_N18
\Chip1|Chip2|Chip1|present_state[9]~29\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[9]~29_combout\ = \Chip1|Chip2|Chip1|present_state[8]~28\ $ (\Chip1|Chip2|Chip1|present_state\(9))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111111110000",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datad => \Chip1|Chip2|Chip1|present_state\(9),
	cin => \Chip1|Chip2|Chip1|present_state[8]~28\,
	combout => \Chip1|Chip2|Chip1|present_state[9]~29_combout\);

-- Location: FF_X55_Y51_N19
\Chip1|Chip2|Chip1|present_state[9]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[9]~29_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(9));

-- Location: LCCOMB_X55_Y51_N30
\Chip1|Chip2|Chip1|LessThan0~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|LessThan0~0_combout\ = (((!\Chip1|Chip2|Chip1|present_state\(9)) # (!\Chip1|Chip2|Chip1|present_state\(7))) # (!\Chip1|Chip2|Chip1|present_state\(8))) # (!\Chip1|Chip2|Chip1|present_state\(6))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0111111111111111",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(6),
	datab => \Chip1|Chip2|Chip1|present_state\(8),
	datac => \Chip1|Chip2|Chip1|present_state\(7),
	datad => \Chip1|Chip2|Chip1|present_state\(9),
	combout => \Chip1|Chip2|Chip1|LessThan0~0_combout\);

-- Location: LCCOMB_X55_Y51_N24
\Chip1|Chip2|Chip1|LessThan0~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|LessThan0~1_combout\ = (((!\Chip1|Chip2|Chip1|present_state\(3)) # (!\Chip1|Chip2|Chip1|present_state\(2))) # (!\Chip1|Chip2|Chip1|present_state\(4))) # (!\Chip1|Chip2|Chip1|present_state\(5))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0111111111111111",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(5),
	datab => \Chip1|Chip2|Chip1|present_state\(4),
	datac => \Chip1|Chip2|Chip1|present_state\(2),
	datad => \Chip1|Chip2|Chip1|present_state\(3),
	combout => \Chip1|Chip2|Chip1|LessThan0~1_combout\);

-- Location: LCCOMB_X54_Y51_N10
\Chip1|Chip2|Chip1|LessThan0~2\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|LessThan0~2_combout\ = (!\Chip1|Chip2|Chip1|present_state\(1)) # (!\Chip1|Chip2|Chip1|present_state\(0))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111111111111",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip1|Chip2|Chip1|present_state\(0),
	datad => \Chip1|Chip2|Chip1|present_state\(1),
	combout => \Chip1|Chip2|Chip1|LessThan0~2_combout\);

-- Location: LCCOMB_X55_Y51_N22
\Chip1|Chip2|Chip1|present_state[5]~12\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip1|present_state[5]~12_combout\ = (\Chip1|Chip1|current_state.Load_regs~q\) # ((!\Chip1|Chip2|Chip1|LessThan0~0_combout\ & (!\Chip1|Chip2|Chip1|LessThan0~1_combout\ & !\Chip1|Chip2|Chip1|LessThan0~2_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111000011110001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|LessThan0~0_combout\,
	datab => \Chip1|Chip2|Chip1|LessThan0~1_combout\,
	datac => \Chip1|Chip1|current_state.Load_regs~q\,
	datad => \Chip1|Chip2|Chip1|LessThan0~2_combout\,
	combout => \Chip1|Chip2|Chip1|present_state[5]~12_combout\);

-- Location: FF_X55_Y51_N1
\Chip1|Chip2|Chip1|present_state[0]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip1|present_state[0]~10_combout\,
	clrn => \CD_L~input_o\,
	sclr => \Chip1|Chip2|Chip1|present_state[5]~12_combout\,
	ena => \Chip1|Chip1|current_state.Idle~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip1|present_state\(0));

-- Location: LCCOMB_X54_Y51_N16
\Chip1|Chip2|Chip3|present_state[9]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip3|present_state[9]~feeder_combout\ = VCC

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111111111111",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	combout => \Chip1|Chip2|Chip3|present_state[9]~feeder_combout\);

-- Location: FF_X54_Y51_N17
\Chip1|Chip2|Chip3|present_state[9]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip3|present_state[9]~feeder_combout\,
	clrn => \CD_L~input_o\,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip3|present_state\(9));

-- Location: LCCOMB_X55_Y51_N28
\Chip1|Chip2|Chip2|Chip9|EQ~2\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip2|Chip9|EQ~2_combout\ = (\Chip1|Chip2|Chip1|present_state\(3)) # ((\Chip1|Chip2|Chip1|present_state\(4)) # (\Chip1|Chip2|Chip3|present_state\(9) $ (\Chip1|Chip2|Chip1|present_state\(1))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1110111111111110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(3),
	datab => \Chip1|Chip2|Chip1|present_state\(4),
	datac => \Chip1|Chip2|Chip3|present_state\(9),
	datad => \Chip1|Chip2|Chip1|present_state\(1),
	combout => \Chip1|Chip2|Chip2|Chip9|EQ~2_combout\);

-- Location: LCCOMB_X55_Y51_N26
\Chip1|Chip2|Chip2|Chip9|EQ~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip2|Chip9|EQ~1_combout\ = (\Chip1|Chip2|Chip1|present_state\(5) & (((!\Chip1|Chip2|Chip1|present_state\(6)) # (!\Chip1|Chip2|Chip3|present_state\(9))) # (!\Chip1|Chip2|Chip1|present_state\(2)))) # (!\Chip1|Chip2|Chip1|present_state\(5) & 
-- ((\Chip1|Chip2|Chip1|present_state\(2)) # ((\Chip1|Chip2|Chip3|present_state\(9)) # (\Chip1|Chip2|Chip1|present_state\(6)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0111111111111110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(5),
	datab => \Chip1|Chip2|Chip1|present_state\(2),
	datac => \Chip1|Chip2|Chip3|present_state\(9),
	datad => \Chip1|Chip2|Chip1|present_state\(6),
	combout => \Chip1|Chip2|Chip2|Chip9|EQ~1_combout\);

-- Location: LCCOMB_X55_Y51_N20
\Chip1|Chip2|Chip2|Chip9|EQ~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip2|Chip9|EQ~0_combout\ = (\Chip1|Chip2|Chip3|present_state\(9) & (((!\Chip1|Chip2|Chip1|present_state\(9)) # (!\Chip1|Chip2|Chip1|present_state\(7))) # (!\Chip1|Chip2|Chip1|present_state\(8)))) # (!\Chip1|Chip2|Chip3|present_state\(9) & 
-- ((\Chip1|Chip2|Chip1|present_state\(8)) # ((\Chip1|Chip2|Chip1|present_state\(7)) # (\Chip1|Chip2|Chip1|present_state\(9)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0111111111111110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip3|present_state\(9),
	datab => \Chip1|Chip2|Chip1|present_state\(8),
	datac => \Chip1|Chip2|Chip1|present_state\(7),
	datad => \Chip1|Chip2|Chip1|present_state\(9),
	combout => \Chip1|Chip2|Chip2|Chip9|EQ~0_combout\);

-- Location: LCCOMB_X56_Y51_N10
\Chip1|Chip2|Chip2|Chip9|EQ~3\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip2|Chip9|EQ~3_combout\ = (\Chip1|Chip2|Chip1|present_state\(0)) # ((\Chip1|Chip2|Chip2|Chip9|EQ~2_combout\) # ((\Chip1|Chip2|Chip2|Chip9|EQ~1_combout\) # (\Chip1|Chip2|Chip2|Chip9|EQ~0_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111111111110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(0),
	datab => \Chip1|Chip2|Chip2|Chip9|EQ~2_combout\,
	datac => \Chip1|Chip2|Chip2|Chip9|EQ~1_combout\,
	datad => \Chip1|Chip2|Chip2|Chip9|EQ~0_combout\,
	combout => \Chip1|Chip2|Chip2|Chip9|EQ~3_combout\);

-- Location: LCCOMB_X56_Y51_N30
\Chip1|Chip1|Selector3~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip1|Selector3~0_combout\ = (!\Chip3|current_state.Pulse_ON~q\ & (\Chip1|Chip1|current_state.Wave_OFF~q\ & \Chip1|Chip2|Chip2|Chip9|EQ~3_combout\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0100010000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip3|current_state.Pulse_ON~q\,
	datab => \Chip1|Chip1|current_state.Wave_OFF~q\,
	datad => \Chip1|Chip2|Chip2|Chip9|EQ~3_combout\,
	combout => \Chip1|Chip1|Selector3~0_combout\);

-- Location: IOIBUF_X51_Y54_N1
\PW[2]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(2),
	o => \PW[2]~input_o\);

-- Location: LCCOMB_X54_Y51_N20
\Chip1|Chip2|Chip5|present_state[2]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip5|present_state[2]~feeder_combout\ = \PW[2]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \PW[2]~input_o\,
	combout => \Chip1|Chip2|Chip5|present_state[2]~feeder_combout\);

-- Location: FF_X54_Y51_N21
\Chip1|Chip2|Chip5|present_state[2]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip5|present_state[2]~feeder_combout\,
	clrn => \CD_L~input_o\,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(2));

-- Location: IOIBUF_X54_Y54_N29
\PW[3]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(3),
	o => \PW[3]~input_o\);

-- Location: FF_X54_Y51_N23
\Chip1|Chip2|Chip5|present_state[3]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	asdata => \PW[3]~input_o\,
	clrn => \CD_L~input_o\,
	sload => VCC,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(3));

-- Location: LCCOMB_X54_Y51_N22
\Chip1|Chip2|Chip4|Chip9|EQ~4\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip4|Chip9|EQ~4_combout\ = (\Chip1|Chip2|Chip1|present_state\(2) & (\Chip1|Chip2|Chip5|present_state\(2) & (\Chip1|Chip2|Chip5|present_state\(3) $ (!\Chip1|Chip2|Chip1|present_state\(3))))) # (!\Chip1|Chip2|Chip1|present_state\(2) & 
-- (!\Chip1|Chip2|Chip5|present_state\(2) & (\Chip1|Chip2|Chip5|present_state\(3) $ (!\Chip1|Chip2|Chip1|present_state\(3)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1001000000001001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip1|present_state\(2),
	datab => \Chip1|Chip2|Chip5|present_state\(2),
	datac => \Chip1|Chip2|Chip5|present_state\(3),
	datad => \Chip1|Chip2|Chip1|present_state\(3),
	combout => \Chip1|Chip2|Chip4|Chip9|EQ~4_combout\);

-- Location: IOIBUF_X51_Y54_N29
\PW[0]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(0),
	o => \PW[0]~input_o\);

-- Location: LCCOMB_X54_Y51_N12
\Chip1|Chip2|Chip5|present_state[0]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip5|present_state[0]~feeder_combout\ = \PW[0]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \PW[0]~input_o\,
	combout => \Chip1|Chip2|Chip5|present_state[0]~feeder_combout\);

-- Location: FF_X54_Y51_N13
\Chip1|Chip2|Chip5|present_state[0]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip5|present_state[0]~feeder_combout\,
	clrn => \CD_L~input_o\,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(0));

-- Location: IOIBUF_X51_Y54_N22
\PW[1]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(1),
	o => \PW[1]~input_o\);

-- Location: FF_X54_Y51_N3
\Chip1|Chip2|Chip5|present_state[1]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	asdata => \PW[1]~input_o\,
	clrn => \CD_L~input_o\,
	sload => VCC,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(1));

-- Location: LCCOMB_X54_Y51_N2
\Chip1|Chip2|Chip4|Chip9|EQ~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip4|Chip9|EQ~0_combout\ = (\Chip1|Chip2|Chip5|present_state\(0) & (\Chip1|Chip2|Chip1|present_state\(0) & (\Chip1|Chip2|Chip5|present_state\(1) $ (!\Chip1|Chip2|Chip1|present_state\(1))))) # (!\Chip1|Chip2|Chip5|present_state\(0) & 
-- (!\Chip1|Chip2|Chip1|present_state\(0) & (\Chip1|Chip2|Chip5|present_state\(1) $ (!\Chip1|Chip2|Chip1|present_state\(1)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1001000000001001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip5|present_state\(0),
	datab => \Chip1|Chip2|Chip1|present_state\(0),
	datac => \Chip1|Chip2|Chip5|present_state\(1),
	datad => \Chip1|Chip2|Chip1|present_state\(1),
	combout => \Chip1|Chip2|Chip4|Chip9|EQ~0_combout\);

-- Location: IOIBUF_X54_Y54_N22
\PW[4]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(4),
	o => \PW[4]~input_o\);

-- Location: LCCOMB_X54_Y51_N24
\Chip1|Chip2|Chip5|present_state[4]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip5|present_state[4]~feeder_combout\ = \PW[4]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \PW[4]~input_o\,
	combout => \Chip1|Chip2|Chip5|present_state[4]~feeder_combout\);

-- Location: FF_X54_Y51_N25
\Chip1|Chip2|Chip5|present_state[4]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip5|present_state[4]~feeder_combout\,
	clrn => \CD_L~input_o\,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(4));

-- Location: IOIBUF_X49_Y54_N1
\PW[5]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(5),
	o => \PW[5]~input_o\);

-- Location: FF_X54_Y51_N15
\Chip1|Chip2|Chip5|present_state[5]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	asdata => \PW[5]~input_o\,
	clrn => \CD_L~input_o\,
	sload => VCC,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(5));

-- Location: LCCOMB_X54_Y51_N14
\Chip1|Chip2|Chip4|Chip9|EQ~3\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip4|Chip9|EQ~3_combout\ = (\Chip1|Chip2|Chip5|present_state\(4) & (\Chip1|Chip2|Chip1|present_state\(4) & (\Chip1|Chip2|Chip1|present_state\(5) $ (!\Chip1|Chip2|Chip5|present_state\(5))))) # (!\Chip1|Chip2|Chip5|present_state\(4) & 
-- (!\Chip1|Chip2|Chip1|present_state\(4) & (\Chip1|Chip2|Chip1|present_state\(5) $ (!\Chip1|Chip2|Chip5|present_state\(5)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1000001001000001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip5|present_state\(4),
	datab => \Chip1|Chip2|Chip1|present_state\(5),
	datac => \Chip1|Chip2|Chip5|present_state\(5),
	datad => \Chip1|Chip2|Chip1|present_state\(4),
	combout => \Chip1|Chip2|Chip4|Chip9|EQ~3_combout\);

-- Location: IOIBUF_X56_Y54_N1
\PW[8]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(8),
	o => \PW[8]~input_o\);

-- Location: LCCOMB_X54_Y51_N0
\Chip1|Chip2|Chip5|present_state[8]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip5|present_state[8]~feeder_combout\ = \PW[8]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \PW[8]~input_o\,
	combout => \Chip1|Chip2|Chip5|present_state[8]~feeder_combout\);

-- Location: FF_X54_Y51_N1
\Chip1|Chip2|Chip5|present_state[8]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip2|Chip5|present_state[8]~feeder_combout\,
	clrn => \CD_L~input_o\,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(8));

-- Location: IOIBUF_X69_Y54_N1
\PW[9]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(9),
	o => \PW[9]~input_o\);

-- Location: FF_X54_Y51_N31
\Chip1|Chip2|Chip5|present_state[9]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	asdata => \PW[9]~input_o\,
	clrn => \CD_L~input_o\,
	sload => VCC,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(9));

-- Location: LCCOMB_X54_Y51_N30
\Chip1|Chip2|Chip4|Chip9|EQ~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip4|Chip9|EQ~1_combout\ = (\Chip1|Chip2|Chip5|present_state\(8) & (\Chip1|Chip2|Chip1|present_state\(8) & (\Chip1|Chip2|Chip1|present_state\(9) $ (!\Chip1|Chip2|Chip5|present_state\(9))))) # (!\Chip1|Chip2|Chip5|present_state\(8) & 
-- (!\Chip1|Chip2|Chip1|present_state\(8) & (\Chip1|Chip2|Chip1|present_state\(9) $ (!\Chip1|Chip2|Chip5|present_state\(9)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1000001001000001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip5|present_state\(8),
	datab => \Chip1|Chip2|Chip1|present_state\(9),
	datac => \Chip1|Chip2|Chip5|present_state\(9),
	datad => \Chip1|Chip2|Chip1|present_state\(8),
	combout => \Chip1|Chip2|Chip4|Chip9|EQ~1_combout\);

-- Location: IOIBUF_X54_Y54_N15
\PW[6]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(6),
	o => \PW[6]~input_o\);

-- Location: FF_X54_Y51_N19
\Chip1|Chip2|Chip5|present_state[6]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	asdata => \PW[6]~input_o\,
	clrn => \CD_L~input_o\,
	sload => VCC,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(6));

-- Location: IOIBUF_X58_Y54_N29
\PW[7]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(7),
	o => \PW[7]~input_o\);

-- Location: FF_X54_Y51_N29
\Chip1|Chip2|Chip5|present_state[7]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	asdata => \PW[7]~input_o\,
	clrn => \CD_L~input_o\,
	sload => VCC,
	ena => \Chip1|Chip1|current_state.Load_regs~q\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip2|Chip5|present_state\(7));

-- Location: LCCOMB_X54_Y51_N28
\Chip1|Chip2|Chip4|Chip7|EQ~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip4|Chip7|EQ~0_combout\ = \Chip1|Chip2|Chip5|present_state\(7) $ (\Chip1|Chip2|Chip1|present_state\(7))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111111110000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip1|Chip2|Chip5|present_state\(7),
	datad => \Chip1|Chip2|Chip1|present_state\(7),
	combout => \Chip1|Chip2|Chip4|Chip7|EQ~0_combout\);

-- Location: LCCOMB_X54_Y51_N18
\Chip1|Chip2|Chip4|Chip9|EQ~2\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip4|Chip9|EQ~2_combout\ = (\Chip1|Chip2|Chip4|Chip9|EQ~1_combout\ & (!\Chip1|Chip2|Chip4|Chip7|EQ~0_combout\ & (\Chip1|Chip2|Chip1|present_state\(6) $ (!\Chip1|Chip2|Chip5|present_state\(6)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000000010000010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip4|Chip9|EQ~1_combout\,
	datab => \Chip1|Chip2|Chip1|present_state\(6),
	datac => \Chip1|Chip2|Chip5|present_state\(6),
	datad => \Chip1|Chip2|Chip4|Chip7|EQ~0_combout\,
	combout => \Chip1|Chip2|Chip4|Chip9|EQ~2_combout\);

-- Location: LCCOMB_X54_Y51_N6
\Chip1|Chip2|Chip4|Chip9|EQ~5\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip2|Chip4|Chip9|EQ~5_combout\ = (\Chip1|Chip2|Chip4|Chip9|EQ~4_combout\ & (\Chip1|Chip2|Chip4|Chip9|EQ~0_combout\ & (\Chip1|Chip2|Chip4|Chip9|EQ~3_combout\ & \Chip1|Chip2|Chip4|Chip9|EQ~2_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1000000000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip2|Chip4|Chip9|EQ~4_combout\,
	datab => \Chip1|Chip2|Chip4|Chip9|EQ~0_combout\,
	datac => \Chip1|Chip2|Chip4|Chip9|EQ~3_combout\,
	datad => \Chip1|Chip2|Chip4|Chip9|EQ~2_combout\,
	combout => \Chip1|Chip2|Chip4|Chip9|EQ~5_combout\);

-- Location: LCCOMB_X56_Y51_N20
\Chip1|Chip1|Selector3~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip1|Selector3~1_combout\ = (\Chip1|Chip1|Selector3~0_combout\) # ((!\Chip3|current_state.Pulse_ON~q\ & (\Chip1|Chip1|current_state.Wave_ON~q\ & \Chip1|Chip2|Chip4|Chip9|EQ~5_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111010011110000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip3|current_state.Pulse_ON~q\,
	datab => \Chip1|Chip1|current_state.Wave_ON~q\,
	datac => \Chip1|Chip1|Selector3~0_combout\,
	datad => \Chip1|Chip2|Chip4|Chip9|EQ~5_combout\,
	combout => \Chip1|Chip1|Selector3~1_combout\);

-- Location: FF_X56_Y51_N21
\Chip1|Chip1|current_state.Wave_OFF\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip1|Selector3~1_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip1|current_state.Wave_OFF~q\);

-- Location: LCCOMB_X56_Y51_N24
\Chip1|Chip1|current_state.Idle~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip1|current_state.Idle~0_combout\ = (\Chip3|current_state.Pulse_ON~q\ & (!\Chip1|Chip1|current_state.Wave_OFF~q\ & ((!\Chip1|Chip1|current_state.Wave_ON~q\)))) # (!\Chip3|current_state.Pulse_ON~q\ & (((\Chip1|Chip1|current_state.Idle~q\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101000001110010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip3|current_state.Pulse_ON~q\,
	datab => \Chip1|Chip1|current_state.Wave_OFF~q\,
	datac => \Chip1|Chip1|current_state.Idle~q\,
	datad => \Chip1|Chip1|current_state.Wave_ON~q\,
	combout => \Chip1|Chip1|current_state.Idle~0_combout\);

-- Location: FF_X56_Y51_N25
\Chip1|Chip1|current_state.Idle\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip1|current_state.Idle~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip1|current_state.Idle~q\);

-- Location: LCCOMB_X56_Y51_N8
\Chip1|Chip1|Selector1~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip1|Selector1~0_combout\ = (\Chip3|current_state.Pulse_ON~q\ & (!\Chip1|Chip1|current_state.Idle~q\)) # (!\Chip3|current_state.Pulse_ON~q\ & (((\Chip1|Chip1|current_state.Wave_OFF~q\ & !\Chip1|Chip2|Chip2|Chip9|EQ~3_combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101000001011100",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|Chip1|current_state.Idle~q\,
	datab => \Chip1|Chip1|current_state.Wave_OFF~q\,
	datac => \Chip3|current_state.Pulse_ON~q\,
	datad => \Chip1|Chip2|Chip2|Chip9|EQ~3_combout\,
	combout => \Chip1|Chip1|Selector1~0_combout\);

-- Location: FF_X56_Y51_N9
\Chip1|Chip1|current_state.Load_regs\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip1|Selector1~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip1|current_state.Load_regs~q\);

-- Location: LCCOMB_X54_Y51_N8
\Chip1|Chip1|Selector2~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|Chip1|Selector2~0_combout\ = (\Chip1|Chip1|current_state.Load_regs~q\) # ((!\Chip3|current_state.Pulse_ON~q\ & (\Chip1|Chip1|current_state.Wave_ON~q\ & !\Chip1|Chip2|Chip4|Chip9|EQ~5_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100110011011100",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip3|current_state.Pulse_ON~q\,
	datab => \Chip1|Chip1|current_state.Load_regs~q\,
	datac => \Chip1|Chip1|current_state.Wave_ON~q\,
	datad => \Chip1|Chip2|Chip4|Chip9|EQ~5_combout\,
	combout => \Chip1|Chip1|Selector2~0_combout\);

-- Location: FF_X54_Y51_N9
\Chip1|Chip1|current_state.Wave_ON\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \Chip4|Chip2|current_state~clkctrl_outclk\,
	d => \Chip1|Chip1|Selector2~0_combout\,
	clrn => \CD_L~input_o\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|Chip1|current_state.Wave_ON~q\);

-- Location: UNVM_X0_Y40_N40
\~QUARTUS_CREATED_UNVM~\ : fiftyfivenm_unvm
-- pragma translate_off
GENERIC MAP (
	addr_range1_end_addr => -1,
	addr_range1_offset => -1,
	addr_range2_end_addr => -1,
	addr_range2_offset => -1,
	addr_range3_offset => -1,
	is_compressed_image => "false",
	is_dual_boot => "false",
	is_eram_skip => "false",
	max_ufm_valid_addr => -1,
	max_valid_addr => -1,
	min_ufm_valid_addr => -1,
	min_valid_addr => -1,
	part_name => "quartus_created_unvm",
	reserve_block => "true")
-- pragma translate_on
PORT MAP (
	nosc_ena => \~QUARTUS_CREATED_GND~I_combout\,
	xe_ye => \~QUARTUS_CREATED_GND~I_combout\,
	se => \~QUARTUS_CREATED_GND~I_combout\,
	busy => \~QUARTUS_CREATED_UNVM~~busy\);

-- Location: ADCBLOCK_X43_Y52_N0
\~QUARTUS_CREATED_ADC1~\ : fiftyfivenm_adcblock
-- pragma translate_off
GENERIC MAP (
	analog_input_pin_mask => 0,
	clkdiv => 1,
	device_partname_fivechar_prefix => "none",
	is_this_first_or_second_adc => 1,
	prescalar => 0,
	pwd => 1,
	refsel => 0,
	reserve_block => "true",
	testbits => 66,
	tsclkdiv => 1,
	tsclksel => 0)
-- pragma translate_on
PORT MAP (
	soc => \~QUARTUS_CREATED_GND~I_combout\,
	usr_pwd => VCC,
	tsen => \~QUARTUS_CREATED_GND~I_combout\,
	chsel => \~QUARTUS_CREATED_ADC1~_CHSEL_bus\,
	eoc => \~QUARTUS_CREATED_ADC1~~eoc\);

-- Location: ADCBLOCK_X43_Y51_N0
\~QUARTUS_CREATED_ADC2~\ : fiftyfivenm_adcblock
-- pragma translate_off
GENERIC MAP (
	analog_input_pin_mask => 0,
	clkdiv => 1,
	device_partname_fivechar_prefix => "none",
	is_this_first_or_second_adc => 2,
	prescalar => 0,
	pwd => 1,
	refsel => 0,
	reserve_block => "true",
	testbits => 66,
	tsclkdiv => 1,
	tsclksel => 0)
-- pragma translate_on
PORT MAP (
	soc => \~QUARTUS_CREATED_GND~I_combout\,
	usr_pwd => VCC,
	tsen => \~QUARTUS_CREATED_GND~I_combout\,
	chsel => \~QUARTUS_CREATED_ADC2~_CHSEL_bus\,
	eoc => \~QUARTUS_CREATED_ADC2~~eoc\);

ww_PWM_out <= \PWM_out~output_o\;

ww_PWM_out_L <= \PWM_out_L~output_o\;

ww_LED_L(1) <= \LED_L[1]~output_o\;

ww_LED_L(2) <= \LED_L[2]~output_o\;

ww_LED_L(3) <= \LED_L[3]~output_o\;

ww_LED_L(4) <= \LED_L[4]~output_o\;

ww_LED_L(5) <= \LED_L[5]~output_o\;

ww_LED_L(6) <= \LED_L[6]~output_o\;

ww_LED_L(7) <= \LED_L[7]~output_o\;

ww_LED_L(8) <= \LED_L[8]~output_o\;

ww_PWM_out_TP <= \PWM_out_TP~output_o\;
END structure;


