-- Copyright (C) 2020  Intel Corporation. All rights reserved.
-- Your use of Intel Corporation's design tools, logic functions 
-- and other software and tools, and any partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Intel Program License 
-- Subscription Agreement, the Intel Quartus Prime License Agreement,
-- the Intel FPGA IP License Agreement, or other applicable license
-- agreement, including, without limitation, that your use is for
-- the sole purpose of programming logic devices manufactured by
-- Intel and sold by Intel or its authorized distributors.  Please
-- refer to the applicable agreement for further details, at
-- https://fpgasoftware.intel.com/eula.

-- ***************************************************************************
-- This file contains a Vhdl test bench template that is freely editable to   
-- suit user's needs .Comments are provided in each section to help the user  
-- fill out necessary details.                                                
-- ***************************************************************************
-- Generated on "01/12/2026 22:46:00"
                                                            
-- Vhdl Test Bench template for design  :  PWM_top
-- 
-- Simulation tool : ModelSim-Altera (VHDL)
-- 

LIBRARY ieee;                                               
USE ieee.std_logic_1164.all;                                

ENTITY PWM_top_vhd_tst IS
END PWM_top_vhd_tst;

ARCHITECTURE PWM_top_arch OF PWM_top_vhd_tst IS
-- constants                                                 
-- ---------------------------------------------------------------------------
	-- Clock period definitions
	-- OSC_CLK_in = 50 MHz. 
	constant OSC_CLK_in_period : time := 20 ns; 

	constant ST_CLick: time := 1.52 ms;

-- signals                                                   
SIGNAL CD : STD_LOGIC;
SIGNAL OSC_CLK_in : STD_LOGIC;
SIGNAL PW : STD_LOGIC_VECTOR(9 DOWNTO 0);
SIGNAL PWM_out : STD_LOGIC;
SIGNAL PWM_out_L : STD_LOGIC;
SIGNAL ST_L : STD_LOGIC;

COMPONENT PWM_top
	PORT (
	CD : IN STD_LOGIC;
	OSC_CLK_in : IN STD_LOGIC;
	PW : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
	PWM_out : OUT STD_LOGIC;
	PWM_out_L : OUT STD_LOGIC;
	ST_L : IN STD_LOGIC
	);
END COMPONENT;

BEGIN
	i1 : PWM_top
	PORT MAP (
-- list connections between master ports and signals
	CD => CD,
	OSC_CLK_in => OSC_CLK_in,
	PW => PW,
	PWM_out => PWM_out,
	PWM_out_L => PWM_out_L,
	ST_L => ST_L
	);
	

-- *** TestBench - User Defined Section ***
	-- Clock process definitions
	CLK_signal :process
	begin
		OSC_CLK_in <= '0';
		wait for OSC_CLK_in_period/2;
		OSC_CLK_in <= '1';
		wait for OSC_CLK_in_period/2;
	end process;

	-- Stimulus process, the idea is to drive some user ST_L clicks
	stim_proc: process
	begin		
	--  A kind of power supply turn on
	wait for 100 ns;	
	wait for OSC_CLK_in_period*2.3;
	ST_L <= '1';
	
	-- Clear direct 
	CD 		<= '1';
	wait for OSC_CLK_in_period*4.56;

	CD 		<= '0';
	wait for OSC_CLK_in_period*8.75;


--------------------------------------------------------------------------------
-- Let us fix a frequency of 1 kHz and a DC = 50%
		-- T_PWM_out = (WP +2)TCLK			T_ON = (PW +1)
	PW <= "0111110011"; -- Value 499   DC = (499+1)/(998 + 2) = 50%
	ST_L <= '1';
	wait for ST_CLick*1.56;
	
	-- Let us simulate a start click 
	
	ST_L <= '0';
	wait for ST_CLick*12.19;
	
	ST_L <= '1';
	wait for ST_CLick*12.86; -- It will have time to run several waveform periods

	-- Let us simulate a stop click 
	
	ST_L <= '0';
	wait for ST_CLick*12.19;
	
	ST_L <= '1';
	wait for ST_CLick*5.33; -- Device stopped (Idle)

-- Another DC = 25%
	PW <= "0011111001"; -- 249  	DC = (250/1000) = 0.25
	wait for ST_CLick*1.1;
	
	-- Let us simulate a start click 
	ST_L <= '0';
	wait for ST_CLick*12.19;
	
	ST_L <= '1';
	wait for ST_CLick*14; -- It will have time to run several waveform periods

	ST_L <= '0';
	wait for ST_CLick*12.19; -- stop pulse to go Idle 
	
	ST_L <= '1';
	wait for ST_CLick*5.8;

--------------------------------------------------------------------------------
			-- Max count for both, WP and PW  (frequency = 975.61 Hz)
	PW <= "1111111110"; -- Value 1022  DC = (1022+1)/(1023 + 2) = 99.8%
	wait for ST_CLick*1.56;
	
	-- Let us simulate a start click 
	ST_L <= '0';
	wait for ST_CLick*12.19;
	
	ST_L <= '1';
	wait for ST_CLick*12.86; -- It will have time to run several waveform periods

	-- Let us simulate a stop click 
	ST_L <= '0';
	wait for ST_CLick*12.19;
	
	ST_L <= '1';
	wait for ST_CLick*1222.33; -- Device stopped (Idle)




--------------------------------------------------------------------------------
			-- Min count for PW  (frequency = 975.61 Hz)
--WP <= "1111111111"; -- This is 1023 (the waveform will be Period = 1025·TCLK
	PW <= "0000000000"; -- Value 0   DC = (0+1)/(1023 + 2) = 0.097%
	wait for ST_CLick*1.56;
	
	-- Let us simulate a start click 
	
	ST_L <= '0';
	wait for ST_CLick*12.19;
	
	ST_L <= '1';
	wait for ST_CLick*14.86; -- It will have time to run several waveform periods

	-- Let us simulate a stop click 
	
	ST_L <= '0';
	wait for ST_CLick*12.19;
	
	ST_L <= '1';
	wait for ST_CLick*12.33; -- Device stopped (Idle)




	wait;

	-- end of user generated stimulus
  
   end process;
  
-- *** End TeST_L Bench - User Defined Section ***

END PWM_top_arch;
