--------------------------------------------------------------------------------
-- UPC - EETAC - DEEL - CSD - DEE
---------------------------------------------------
-- Example of a dedicated processor translated using plan C2
-- Programmable Pulse Width Modulator (PWM) based on PIC TMR2-PWM architecture
-- This descriptions is the translation of Fig. 4 at the reference project:  
-- https://digsys.upc.edu/csd/DEE/dimmer/phaseB/FPGA/Dimmer_FPGA.html

--------------------------------------------------------------------------------
LIBRARY ieee ;
USE ieee.std_logic_1164.all ;

ENTITY PWM_top IS  
	PORT (
		OSC_CLK_in	: IN	STD_LOGIC;
		CD_L		: IN	STD_LOGIC;	-- active-low key
		PW			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --pulse width 
		ST_L		: IN	STD_LOGIC; --start/stop pus-button pulse active-low
		PWM_out		: OUT	STD_LOGIC;-- LED(9)
		PWM_out_L	: OUT	STD_LOGIC; -- LED(0)
		LED_L		: OUT STD_LOGIC_VECTOR(8 downto 1); --Unused LED
		PWM_out_TP	: OUT	STD_LOGIC -- replicated output for lab measurements
									-- Test point assigned to an header socket
	);
	END PWM_top; 

ARCHITECTURE dedicated_processor OF PWM_top IS

COMPONENT PWM IS
	PORT (
		CLK			: IN	STD_LOGIC;
		CD			: IN	STD_LOGIC;
		WP			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --wave period
		PW			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --pulse width 
		ST			: IN	STD_LOGIC; -- start/stop pulse
		PWM_out		: OUT	STD_LOGIC;
		PWM_out_L	: OUT	STD_LOGIC
	);
END COMPONENT;


COMPONENT CLK_Generator IS
	PORT(	
		OSC_CLK_in	: IN		STD_LOGIC;
		CD 			: IN		STD_LOGIC;
		CE			: IN		STD_LOGIC;
		CLK_A_SQ	: OUT		STD_LOGIC;
		CLK_B_SQ	: OUT		STD_LOGIC
	);
END COMPONENT;


COMPONENT Debouncing_filter IS
	Port (
		CLK		: IN	STD_LOGIC;
		PB_L	: IN	STD_LOGIC;
		CD		: IN 	STD_LOGIC;
		QA		: OUT	STD_LOGIC;
		QB		: OUT	STD_LOGIC
	);
END COMPONENT;

COMPONENT Pulse_gen IS
	Port (
		CLK		: IN	STD_LOGIC;
		CD		: IN 	STD_LOGIC;
		D		: IN	STD_LOGIC;
		Q		: OUT	STD_LOGIC
	);
END COMPONENT;

	SIGNAL CLK, CLK_PB		: STD_LOGIC;
	SIGNAL QB,PB, ST, CD	: STD_LOGIC;
	SIGNAL Wave_out			: STD_LOGIC;
	
BEGIN
-- Instantiation of components

Chip1:	PWM
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK			=> CLK,
		CD			=> CD, 
-- Let's fix WP = 998		
--------------------------------------------------------------------------------
		WP			=> "1111100110",-- waveform period = (WP+2)T_CLK= 1000T_CLK
		PW			=> PW,-- pulse duration (Adjustable using external switches
		ST			=> ST,
		PWM_out		=> Wave_out,
		PWM_out_L	=> PWM_out_L
	);
	
Chip4:	CLK_Generator
-- from component name 	=> to signal or port name	
	PORT MAP (
		OSC_CLK_in		=> OSC_CLK_in,
		CD				=> CD, 
		CE				=> '1',
		CLK_A_SQ		=> CLK,
		CLK_B_SQ		=> CLK_PB
	);


Chip2:	Debouncing_filter
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK				=> CLK_PB,--a low-freq for sampling the button (200 Hz)
		PB_L			=> ST_L, 
		CD				=> CD,
		QA				=> PB,
		QB				=> QB
	);

Chip3:	Pulse_gen
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK				=> CLK,
		CD				=> CD,
		D				=> PB,
		Q				=> ST
	);
	
	-- The unused LED will be reset
	LED_L <= "00000000";
	CD <= not(CD_L);
	PWM_out <= Wave_out;
	PWM_out_TP <= Wave_out; -- replicated
END dedicated_processor;
