--------------------------------------------------------------------------------
-- UPC - EETAC - DEEL - CSD - DEE
---------------------------------------------------
-- Example of a dedicated processor translated using plan C2
-- Programmable Pulse Width Modulator (PWM) based on PIC TMR2-PWM architecture
-- This descriptions is the translation of Fig. 4 at the reference project:  
-- https://digsys.upc.edu/csd/DEE/dimmer/phaseB/FPGA/Dimmer_FPGA.html

--------------------------------------------------------------------------------
LIBRARY ieee ;
USE ieee.std_logic_1164.all ;

ENTITY PWM IS  
	PORT (
		CLK			: IN	STD_LOGIC;
		CD			: IN	STD_LOGIC;
		WP			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --wave period
		PW			: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --pulse width 
		ST			: IN	STD_LOGIC; -- start/stop pulse
		PWM_out		: OUT	STD_LOGIC;
		PWM_out_L	: OUT	STD_LOGIC
	);
	END PWM; 

ARCHITECTURE dedicated_processor OF PWM IS

COMPONENT Datapath IS
	PORT (
		CLK		: IN	STD_LOGIC;
		CD		: IN	STD_LOGIC;
		WP		: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --wave period
		PW		: IN	STD_LOGIC_VECTOR (9 DOWNTO 0); --pulse width 
		LDR		: IN 	STD_LOGIC; -- to load new PW and WP values 
		CE		: IN 	STD_LOGIC;
		WS		: OUT	STD_LOGIC; -- status signal
		WR		: OUT	STD_LOGIC -- status signal
	);
END COMPONENT;

COMPONENT FSM IS
	Port (
		CLK		: IN	STD_LOGIC;
		CD		: IN	STD_LOGIC;
		ST		: IN	STD_LOGIC;
		WR		: IN	STD_LOGIC;
		WS		: IN	STD_LOGIC;
		LDR		: OUT	STD_LOGIC;
		CE		: OUT	STD_LOGIC;
		W		: OUT	STD_LOGIC
	);
END COMPONENT;

	SIGNAL  WR, WS, LDReg, CEnable, W	: STD_LOGIC; 

BEGIN
-- Instantiation of components

Chip1:	FSM
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK		=> CLK,
		CD		=> CD, 
		ST		=> ST, -- start/stop pulse
		WS		=> WS,
		WR		=> WR,
		LDR		=> LDReg, --to load new PW and WP values
		CE		=> CEnable, 
		W		=> W
	);

Chip2:	Datapath
-- from component name 	=> to signal or port name	
	PORT MAP (
		CLK		=> CLK,
		CD		=> CD, 
		WS		=> WS,
		WR		=> WR,
		PW		=> PW,
		WP		=> WP,
		LDR		=> LDReg,
		CE		=> CEnable
	);

PWM_out_L <= not(W);
PWM_out <= W;

END dedicated_processor;
