-- Copyright (C) 2020  Intel Corporation. All rights reserved.
-- Your use of Intel Corporation's design tools, logic functions 
-- and other software and tools, and any partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Intel Program License 
-- Subscription Agreement, the Intel Quartus Prime License Agreement,
-- the Intel FPGA IP License Agreement, or other applicable license
-- agreement, including, without limitation, that your use is for
-- the sole purpose of programming logic devices manufactured by
-- Intel and sold by Intel or its authorized distributors.  Please
-- refer to the applicable agreement for further details, at
-- https://fpgasoftware.intel.com/eula.

-- VENDOR "Altera"
-- PROGRAM "Quartus Prime"
-- VERSION "Version 20.1.1 Build 720 11/11/2020 SJ Lite Edition"

-- DATE "01/11/2026 23:49:15"

-- 
-- Device: Altera 10M50DAF484C7G Package FBGA484
-- 

-- 
-- This VHDL file should be used for ModelSim-Altera (VHDL) only
-- 

LIBRARY FIFTYFIVENM;
LIBRARY IEEE;
USE FIFTYFIVENM.FIFTYFIVENM_COMPONENTS.ALL;
USE IEEE.STD_LOGIC_1164.ALL;

ENTITY 	hard_block IS
    PORT (
	devoe : IN std_logic;
	devclrn : IN std_logic;
	devpor : IN std_logic
	);
END hard_block;

-- Design Ports Information
-- ~ALTERA_TMS~	=>  Location: PIN_H2,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_TCK~	=>  Location: PIN_G2,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_TDI~	=>  Location: PIN_L4,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_TDO~	=>  Location: PIN_M5,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- ~ALTERA_CONFIG_SEL~	=>  Location: PIN_H10,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- ~ALTERA_nCONFIG~	=>  Location: PIN_H9,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_nSTATUS~	=>  Location: PIN_G9,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default
-- ~ALTERA_CONF_DONE~	=>  Location: PIN_F8,	 I/O Standard: 2.5 V Schmitt Trigger,	 Current Strength: Default


ARCHITECTURE structure OF hard_block IS
SIGNAL gnd : std_logic := '0';
SIGNAL vcc : std_logic := '1';
SIGNAL unknown : std_logic := 'X';
SIGNAL ww_devoe : std_logic;
SIGNAL ww_devclrn : std_logic;
SIGNAL ww_devpor : std_logic;
SIGNAL \~ALTERA_TMS~~padout\ : std_logic;
SIGNAL \~ALTERA_TCK~~padout\ : std_logic;
SIGNAL \~ALTERA_TDI~~padout\ : std_logic;
SIGNAL \~ALTERA_CONFIG_SEL~~padout\ : std_logic;
SIGNAL \~ALTERA_nCONFIG~~padout\ : std_logic;
SIGNAL \~ALTERA_nSTATUS~~padout\ : std_logic;
SIGNAL \~ALTERA_CONF_DONE~~padout\ : std_logic;
SIGNAL \~ALTERA_TMS~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_TCK~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_TDI~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_CONFIG_SEL~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_nCONFIG~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_nSTATUS~~ibuf_o\ : std_logic;
SIGNAL \~ALTERA_CONF_DONE~~ibuf_o\ : std_logic;

BEGIN

ww_devoe <= devoe;
ww_devclrn <= devclrn;
ww_devpor <= devpor;
END structure;


LIBRARY ALTERA;
LIBRARY FIFTYFIVENM;
LIBRARY IEEE;
USE ALTERA.ALTERA_PRIMITIVES_COMPONENTS.ALL;
USE FIFTYFIVENM.FIFTYFIVENM_COMPONENTS.ALL;
USE IEEE.STD_LOGIC_1164.ALL;

ENTITY 	PWM IS
    PORT (
	CLK : IN std_logic;
	CD : IN std_logic;
	WP : IN std_logic_vector(9 DOWNTO 0);
	PW : IN std_logic_vector(9 DOWNTO 0);
	ST : IN std_logic;
	PWM_out : OUT std_logic;
	PWM_out_L : OUT std_logic
	);
END PWM;

-- Design Ports Information
-- PWM_out	=>  Location: PIN_A11,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PWM_out_L	=>  Location: PIN_C10,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- ST	=>  Location: PIN_H13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- CLK	=>  Location: PIN_M8,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- CD	=>  Location: PIN_M9,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[1]	=>  Location: PIN_A14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[0]	=>  Location: PIN_J12,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[8]	=>  Location: PIN_D13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[7]	=>  Location: PIN_E12,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[6]	=>  Location: PIN_E13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[9]	=>  Location: PIN_C11,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[5]	=>  Location: PIN_D14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[4]	=>  Location: PIN_C12,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[3]	=>  Location: PIN_A12,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- WP[2]	=>  Location: PIN_B14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[9]	=>  Location: PIN_A15,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[8]	=>  Location: PIN_B15,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[7]	=>  Location: PIN_C13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[6]	=>  Location: PIN_A13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[5]	=>  Location: PIN_J13,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[4]	=>  Location: PIN_A16,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[3]	=>  Location: PIN_B16,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[2]	=>  Location: PIN_C15,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[1]	=>  Location: PIN_C14,	 I/O Standard: 2.5 V,	 Current Strength: Default
-- PW[0]	=>  Location: PIN_H14,	 I/O Standard: 2.5 V,	 Current Strength: Default


ARCHITECTURE structure OF PWM IS
SIGNAL gnd : std_logic := '0';
SIGNAL vcc : std_logic := '1';
SIGNAL unknown : std_logic := 'X';
SIGNAL devoe : std_logic := '1';
SIGNAL devclrn : std_logic := '1';
SIGNAL devpor : std_logic := '1';
SIGNAL ww_devoe : std_logic;
SIGNAL ww_devclrn : std_logic;
SIGNAL ww_devpor : std_logic;
SIGNAL ww_CLK : std_logic;
SIGNAL ww_CD : std_logic;
SIGNAL ww_WP : std_logic_vector(9 DOWNTO 0);
SIGNAL ww_PW : std_logic_vector(9 DOWNTO 0);
SIGNAL ww_ST : std_logic;
SIGNAL ww_PWM_out : std_logic;
SIGNAL ww_PWM_out_L : std_logic;
SIGNAL \~QUARTUS_CREATED_ADC1~_CHSEL_bus\ : std_logic_vector(4 DOWNTO 0);
SIGNAL \~QUARTUS_CREATED_ADC2~_CHSEL_bus\ : std_logic_vector(4 DOWNTO 0);
SIGNAL \CD~inputclkctrl_INCLK_bus\ : std_logic_vector(3 DOWNTO 0);
SIGNAL \CLK~inputclkctrl_INCLK_bus\ : std_logic_vector(3 DOWNTO 0);
SIGNAL \~QUARTUS_CREATED_GND~I_combout\ : std_logic;
SIGNAL \~QUARTUS_CREATED_UNVM~~busy\ : std_logic;
SIGNAL \~QUARTUS_CREATED_ADC1~~eoc\ : std_logic;
SIGNAL \~QUARTUS_CREATED_ADC2~~eoc\ : std_logic;
SIGNAL \PWM_out~output_o\ : std_logic;
SIGNAL \PWM_out_L~output_o\ : std_logic;
SIGNAL \CLK~input_o\ : std_logic;
SIGNAL \CLK~inputclkctrl_outclk\ : std_logic;
SIGNAL \ST~input_o\ : std_logic;
SIGNAL \WP[1]~input_o\ : std_logic;
SIGNAL \Chip2|Chip3|present_state[1]~feeder_combout\ : std_logic;
SIGNAL \CD~input_o\ : std_logic;
SIGNAL \CD~inputclkctrl_outclk\ : std_logic;
SIGNAL \Chip1|current_state.Load_regs~0_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[0]~10_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[1]~13\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[2]~16_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[9]~15_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[2]~17\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[3]~18_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[3]~19\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[4]~20_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[4]~21\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[5]~22_combout\ : std_logic;
SIGNAL \Chip2|Chip1|LessThan0~1_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[5]~23\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[6]~24_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[6]~25\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[7]~26_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[7]~27\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[8]~28_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[8]~29\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[9]~30_combout\ : std_logic;
SIGNAL \Chip2|Chip1|LessThan0~0_combout\ : std_logic;
SIGNAL \Chip2|Chip1|LessThan0~2_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[9]~14_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[0]~11\ : std_logic;
SIGNAL \Chip2|Chip1|present_state[1]~12_combout\ : std_logic;
SIGNAL \WP[0]~input_o\ : std_logic;
SIGNAL \Chip2|Chip2|Chip9|EQ~0_combout\ : std_logic;
SIGNAL \WP[3]~input_o\ : std_logic;
SIGNAL \WP[2]~input_o\ : std_logic;
SIGNAL \Chip2|Chip2|Chip9|EQ~4_combout\ : std_logic;
SIGNAL \WP[5]~input_o\ : std_logic;
SIGNAL \Chip2|Chip3|present_state[5]~feeder_combout\ : std_logic;
SIGNAL \WP[4]~input_o\ : std_logic;
SIGNAL \Chip2|Chip2|Chip9|EQ~3_combout\ : std_logic;
SIGNAL \WP[8]~input_o\ : std_logic;
SIGNAL \Chip2|Chip2|Chip8|EQ~0_combout\ : std_logic;
SIGNAL \WP[9]~input_o\ : std_logic;
SIGNAL \WP[7]~input_o\ : std_logic;
SIGNAL \Chip2|Chip3|present_state[7]~feeder_combout\ : std_logic;
SIGNAL \WP[6]~input_o\ : std_logic;
SIGNAL \Chip2|Chip2|Chip9|EQ~1_combout\ : std_logic;
SIGNAL \Chip2|Chip2|Chip9|EQ~2_combout\ : std_logic;
SIGNAL \Chip2|Chip2|Chip9|EQ~5_combout\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_1~0_combout\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_1~q\ : std_logic;
SIGNAL \PW[1]~input_o\ : std_logic;
SIGNAL \PW[0]~input_o\ : std_logic;
SIGNAL \Chip2|Chip5|present_state[0]~feeder_combout\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~5_combout\ : std_logic;
SIGNAL \PW[6]~input_o\ : std_logic;
SIGNAL \PW[7]~input_o\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~1_combout\ : std_logic;
SIGNAL \PW[8]~input_o\ : std_logic;
SIGNAL \PW[9]~input_o\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~0_combout\ : std_logic;
SIGNAL \PW[4]~input_o\ : std_logic;
SIGNAL \Chip2|Chip5|present_state[4]~feeder_combout\ : std_logic;
SIGNAL \PW[5]~input_o\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~2_combout\ : std_logic;
SIGNAL \PW[2]~input_o\ : std_logic;
SIGNAL \PW[3]~input_o\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~3_combout\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~4_combout\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~6_combout\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~7_combout\ : std_logic;
SIGNAL \Chip1|current_state.state_bit_0~q\ : std_logic;
SIGNAL \Chip1|current_state.Wave_ON~0_combout\ : std_logic;
SIGNAL \Chip2|Chip1|present_state\ : std_logic_vector(9 DOWNTO 0);
SIGNAL \Chip2|Chip3|present_state\ : std_logic_vector(9 DOWNTO 0);
SIGNAL \Chip2|Chip5|present_state\ : std_logic_vector(9 DOWNTO 0);
SIGNAL \ALT_INV_CD~inputclkctrl_outclk\ : std_logic;
SIGNAL \Chip1|ALT_INV_current_state.Wave_ON~0_combout\ : std_logic;

COMPONENT hard_block
    PORT (
	devoe : IN std_logic;
	devclrn : IN std_logic;
	devpor : IN std_logic);
END COMPONENT;

BEGIN

ww_CLK <= CLK;
ww_CD <= CD;
ww_WP <= WP;
ww_PW <= PW;
ww_ST <= ST;
PWM_out <= ww_PWM_out;
PWM_out_L <= ww_PWM_out_L;
ww_devoe <= devoe;
ww_devclrn <= devclrn;
ww_devpor <= devpor;

\~QUARTUS_CREATED_ADC1~_CHSEL_bus\ <= (\~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\);

\~QUARTUS_CREATED_ADC2~_CHSEL_bus\ <= (\~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\ & \~QUARTUS_CREATED_GND~I_combout\);

\CD~inputclkctrl_INCLK_bus\ <= (vcc & vcc & vcc & \CD~input_o\);

\CLK~inputclkctrl_INCLK_bus\ <= (vcc & vcc & vcc & \CLK~input_o\);
\ALT_INV_CD~inputclkctrl_outclk\ <= NOT \CD~inputclkctrl_outclk\;
\Chip1|ALT_INV_current_state.Wave_ON~0_combout\ <= NOT \Chip1|current_state.Wave_ON~0_combout\;
auto_generated_inst : hard_block
PORT MAP (
	devoe => ww_devoe,
	devclrn => ww_devclrn,
	devpor => ww_devpor);

-- Location: LCCOMB_X44_Y46_N16
\~QUARTUS_CREATED_GND~I\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \~QUARTUS_CREATED_GND~I_combout\ = GND

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000000000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	combout => \~QUARTUS_CREATED_GND~I_combout\);

-- Location: IOOBUF_X51_Y54_N9
\PWM_out~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => \Chip1|current_state.Wave_ON~0_combout\,
	devoe => ww_devoe,
	o => \PWM_out~output_o\);

-- Location: IOOBUF_X51_Y54_N30
\PWM_out_L~output\ : fiftyfivenm_io_obuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	open_drain_output => "false")
-- pragma translate_on
PORT MAP (
	i => \Chip1|ALT_INV_current_state.Wave_ON~0_combout\,
	devoe => ww_devoe,
	o => \PWM_out_L~output_o\);

-- Location: IOIBUF_X0_Y18_N15
\CLK~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_CLK,
	o => \CLK~input_o\);

-- Location: CLKCTRL_G3
\CLK~inputclkctrl\ : fiftyfivenm_clkctrl
-- pragma translate_off
GENERIC MAP (
	clock_type => "global clock",
	ena_register_mode => "none")
-- pragma translate_on
PORT MAP (
	inclk => \CLK~inputclkctrl_INCLK_bus\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	outclk => \CLK~inputclkctrl_outclk\);

-- Location: IOIBUF_X54_Y54_N1
\ST~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_ST,
	o => \ST~input_o\);

-- Location: IOIBUF_X58_Y54_N29
\WP[1]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(1),
	o => \WP[1]~input_o\);

-- Location: LCCOMB_X57_Y52_N4
\Chip2|Chip3|present_state[1]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip3|present_state[1]~feeder_combout\ = \WP[1]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \WP[1]~input_o\,
	combout => \Chip2|Chip3|present_state[1]~feeder_combout\);

-- Location: IOIBUF_X0_Y18_N22
\CD~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_CD,
	o => \CD~input_o\);

-- Location: CLKCTRL_G4
\CD~inputclkctrl\ : fiftyfivenm_clkctrl
-- pragma translate_off
GENERIC MAP (
	clock_type => "global clock",
	ena_register_mode => "none")
-- pragma translate_on
PORT MAP (
	inclk => \CD~inputclkctrl_INCLK_bus\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	outclk => \CD~inputclkctrl_outclk\);

-- Location: LCCOMB_X56_Y52_N12
\Chip1|current_state.Load_regs~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.Load_regs~0_combout\ = (\Chip1|current_state.state_bit_0~q\ & !\Chip1|current_state.state_bit_1~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000000011110000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip1|current_state.state_bit_0~q\,
	datad => \Chip1|current_state.state_bit_1~q\,
	combout => \Chip1|current_state.Load_regs~0_combout\);

-- Location: FF_X57_Y52_N5
\Chip2|Chip3|present_state[1]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip3|present_state[1]~feeder_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(1));

-- Location: LCCOMB_X58_Y52_N6
\Chip2|Chip1|present_state[0]~10\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[0]~10_combout\ = \Chip2|Chip1|present_state\(0) $ (VCC)
-- \Chip2|Chip1|present_state[0]~11\ = CARRY(\Chip2|Chip1|present_state\(0))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101010110101010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(0),
	datad => VCC,
	combout => \Chip2|Chip1|present_state[0]~10_combout\,
	cout => \Chip2|Chip1|present_state[0]~11\);

-- Location: LCCOMB_X58_Y52_N8
\Chip2|Chip1|present_state[1]~12\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[1]~12_combout\ = (\Chip2|Chip1|present_state\(1) & (!\Chip2|Chip1|present_state[0]~11\)) # (!\Chip2|Chip1|present_state\(1) & ((\Chip2|Chip1|present_state[0]~11\) # (GND)))
-- \Chip2|Chip1|present_state[1]~13\ = CARRY((!\Chip2|Chip1|present_state[0]~11\) # (!\Chip2|Chip1|present_state\(1)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011110000111111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip2|Chip1|present_state\(1),
	datad => VCC,
	cin => \Chip2|Chip1|present_state[0]~11\,
	combout => \Chip2|Chip1|present_state[1]~12_combout\,
	cout => \Chip2|Chip1|present_state[1]~13\);

-- Location: LCCOMB_X58_Y52_N10
\Chip2|Chip1|present_state[2]~16\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[2]~16_combout\ = (\Chip2|Chip1|present_state\(2) & (\Chip2|Chip1|present_state[1]~13\ $ (GND))) # (!\Chip2|Chip1|present_state\(2) & (!\Chip2|Chip1|present_state[1]~13\ & VCC))
-- \Chip2|Chip1|present_state[2]~17\ = CARRY((\Chip2|Chip1|present_state\(2) & !\Chip2|Chip1|present_state[1]~13\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1010010100001010",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(2),
	datad => VCC,
	cin => \Chip2|Chip1|present_state[1]~13\,
	combout => \Chip2|Chip1|present_state[2]~16_combout\,
	cout => \Chip2|Chip1|present_state[2]~17\);

-- Location: LCCOMB_X58_Y52_N4
\Chip2|Chip1|present_state[9]~15\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[9]~15_combout\ = (\Chip1|current_state.state_bit_1~q\) # (\Chip1|current_state.state_bit_0~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111111110000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip1|current_state.state_bit_1~q\,
	datad => \Chip1|current_state.state_bit_0~q\,
	combout => \Chip2|Chip1|present_state[9]~15_combout\);

-- Location: FF_X58_Y52_N11
\Chip2|Chip1|present_state[2]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[2]~16_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(2));

-- Location: LCCOMB_X58_Y52_N12
\Chip2|Chip1|present_state[3]~18\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[3]~18_combout\ = (\Chip2|Chip1|present_state\(3) & (!\Chip2|Chip1|present_state[2]~17\)) # (!\Chip2|Chip1|present_state\(3) & ((\Chip2|Chip1|present_state[2]~17\) # (GND)))
-- \Chip2|Chip1|present_state[3]~19\ = CARRY((!\Chip2|Chip1|present_state[2]~17\) # (!\Chip2|Chip1|present_state\(3)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101101001011111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(3),
	datad => VCC,
	cin => \Chip2|Chip1|present_state[2]~17\,
	combout => \Chip2|Chip1|present_state[3]~18_combout\,
	cout => \Chip2|Chip1|present_state[3]~19\);

-- Location: FF_X58_Y52_N13
\Chip2|Chip1|present_state[3]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[3]~18_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(3));

-- Location: LCCOMB_X58_Y52_N14
\Chip2|Chip1|present_state[4]~20\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[4]~20_combout\ = (\Chip2|Chip1|present_state\(4) & (\Chip2|Chip1|present_state[3]~19\ $ (GND))) # (!\Chip2|Chip1|present_state\(4) & (!\Chip2|Chip1|present_state[3]~19\ & VCC))
-- \Chip2|Chip1|present_state[4]~21\ = CARRY((\Chip2|Chip1|present_state\(4) & !\Chip2|Chip1|present_state[3]~19\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip2|Chip1|present_state\(4),
	datad => VCC,
	cin => \Chip2|Chip1|present_state[3]~19\,
	combout => \Chip2|Chip1|present_state[4]~20_combout\,
	cout => \Chip2|Chip1|present_state[4]~21\);

-- Location: FF_X58_Y52_N15
\Chip2|Chip1|present_state[4]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[4]~20_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(4));

-- Location: LCCOMB_X58_Y52_N16
\Chip2|Chip1|present_state[5]~22\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[5]~22_combout\ = (\Chip2|Chip1|present_state\(5) & (!\Chip2|Chip1|present_state[4]~21\)) # (!\Chip2|Chip1|present_state\(5) & ((\Chip2|Chip1|present_state[4]~21\) # (GND)))
-- \Chip2|Chip1|present_state[5]~23\ = CARRY((!\Chip2|Chip1|present_state[4]~21\) # (!\Chip2|Chip1|present_state\(5)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011110000111111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip2|Chip1|present_state\(5),
	datad => VCC,
	cin => \Chip2|Chip1|present_state[4]~21\,
	combout => \Chip2|Chip1|present_state[5]~22_combout\,
	cout => \Chip2|Chip1|present_state[5]~23\);

-- Location: FF_X58_Y52_N17
\Chip2|Chip1|present_state[5]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[5]~22_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(5));

-- Location: LCCOMB_X58_Y52_N26
\Chip2|Chip1|LessThan0~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|LessThan0~1_combout\ = (((!\Chip2|Chip1|present_state\(2)) # (!\Chip2|Chip1|present_state\(4))) # (!\Chip2|Chip1|present_state\(5))) # (!\Chip2|Chip1|present_state\(3))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0111111111111111",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(3),
	datab => \Chip2|Chip1|present_state\(5),
	datac => \Chip2|Chip1|present_state\(4),
	datad => \Chip2|Chip1|present_state\(2),
	combout => \Chip2|Chip1|LessThan0~1_combout\);

-- Location: LCCOMB_X58_Y52_N18
\Chip2|Chip1|present_state[6]~24\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[6]~24_combout\ = (\Chip2|Chip1|present_state\(6) & (\Chip2|Chip1|present_state[5]~23\ $ (GND))) # (!\Chip2|Chip1|present_state\(6) & (!\Chip2|Chip1|present_state[5]~23\ & VCC))
-- \Chip2|Chip1|present_state[6]~25\ = CARRY((\Chip2|Chip1|present_state\(6) & !\Chip2|Chip1|present_state[5]~23\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1100001100001100",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip2|Chip1|present_state\(6),
	datad => VCC,
	cin => \Chip2|Chip1|present_state[5]~23\,
	combout => \Chip2|Chip1|present_state[6]~24_combout\,
	cout => \Chip2|Chip1|present_state[6]~25\);

-- Location: FF_X58_Y52_N19
\Chip2|Chip1|present_state[6]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[6]~24_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(6));

-- Location: LCCOMB_X58_Y52_N20
\Chip2|Chip1|present_state[7]~26\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[7]~26_combout\ = (\Chip2|Chip1|present_state\(7) & (!\Chip2|Chip1|present_state[6]~25\)) # (!\Chip2|Chip1|present_state\(7) & ((\Chip2|Chip1|present_state[6]~25\) # (GND)))
-- \Chip2|Chip1|present_state[7]~27\ = CARRY((!\Chip2|Chip1|present_state[6]~25\) # (!\Chip2|Chip1|present_state\(7)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0011110000111111",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datab => \Chip2|Chip1|present_state\(7),
	datad => VCC,
	cin => \Chip2|Chip1|present_state[6]~25\,
	combout => \Chip2|Chip1|present_state[7]~26_combout\,
	cout => \Chip2|Chip1|present_state[7]~27\);

-- Location: FF_X58_Y52_N21
\Chip2|Chip1|present_state[7]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[7]~26_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(7));

-- Location: LCCOMB_X58_Y52_N22
\Chip2|Chip1|present_state[8]~28\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[8]~28_combout\ = (\Chip2|Chip1|present_state\(8) & (\Chip2|Chip1|present_state[7]~27\ $ (GND))) # (!\Chip2|Chip1|present_state\(8) & (!\Chip2|Chip1|present_state[7]~27\ & VCC))
-- \Chip2|Chip1|present_state[8]~29\ = CARRY((\Chip2|Chip1|present_state\(8) & !\Chip2|Chip1|present_state[7]~27\))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1010010100001010",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(8),
	datad => VCC,
	cin => \Chip2|Chip1|present_state[7]~27\,
	combout => \Chip2|Chip1|present_state[8]~28_combout\,
	cout => \Chip2|Chip1|present_state[8]~29\);

-- Location: FF_X58_Y52_N23
\Chip2|Chip1|present_state[8]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[8]~28_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(8));

-- Location: LCCOMB_X58_Y52_N24
\Chip2|Chip1|present_state[9]~30\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[9]~30_combout\ = \Chip2|Chip1|present_state[8]~29\ $ (\Chip2|Chip1|present_state\(9))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111111110000",
	sum_lutc_input => "cin")
-- pragma translate_on
PORT MAP (
	datad => \Chip2|Chip1|present_state\(9),
	cin => \Chip2|Chip1|present_state[8]~29\,
	combout => \Chip2|Chip1|present_state[9]~30_combout\);

-- Location: FF_X58_Y52_N25
\Chip2|Chip1|present_state[9]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[9]~30_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(9));

-- Location: LCCOMB_X58_Y52_N28
\Chip2|Chip1|LessThan0~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|LessThan0~0_combout\ = (((!\Chip2|Chip1|present_state\(7)) # (!\Chip2|Chip1|present_state\(9))) # (!\Chip2|Chip1|present_state\(6))) # (!\Chip2|Chip1|present_state\(8))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0111111111111111",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(8),
	datab => \Chip2|Chip1|present_state\(6),
	datac => \Chip2|Chip1|present_state\(9),
	datad => \Chip2|Chip1|present_state\(7),
	combout => \Chip2|Chip1|LessThan0~0_combout\);

-- Location: LCCOMB_X58_Y52_N0
\Chip2|Chip1|LessThan0~2\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|LessThan0~2_combout\ = (!\Chip2|Chip1|present_state\(0)) # (!\Chip2|Chip1|present_state\(1))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111111111111",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip2|Chip1|present_state\(1),
	datad => \Chip2|Chip1|present_state\(0),
	combout => \Chip2|Chip1|LessThan0~2_combout\);

-- Location: LCCOMB_X58_Y52_N2
\Chip2|Chip1|present_state[9]~14\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip1|present_state[9]~14_combout\ = (\Chip1|current_state.Load_regs~0_combout\) # ((!\Chip2|Chip1|LessThan0~1_combout\ & (!\Chip2|Chip1|LessThan0~0_combout\ & !\Chip2|Chip1|LessThan0~2_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111000011110001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|LessThan0~1_combout\,
	datab => \Chip2|Chip1|LessThan0~0_combout\,
	datac => \Chip1|current_state.Load_regs~0_combout\,
	datad => \Chip2|Chip1|LessThan0~2_combout\,
	combout => \Chip2|Chip1|present_state[9]~14_combout\);

-- Location: FF_X58_Y52_N7
\Chip2|Chip1|present_state[0]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[0]~10_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(0));

-- Location: FF_X58_Y52_N9
\Chip2|Chip1|present_state[1]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip1|present_state[1]~12_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sclr => \Chip2|Chip1|present_state[9]~14_combout\,
	ena => \Chip2|Chip1|present_state[9]~15_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip1|present_state\(1));

-- Location: IOIBUF_X54_Y54_N8
\WP[0]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(0),
	o => \WP[0]~input_o\);

-- Location: FF_X57_Y52_N3
\Chip2|Chip3|present_state[0]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \WP[0]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(0));

-- Location: LCCOMB_X57_Y52_N2
\Chip2|Chip2|Chip9|EQ~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip2|Chip9|EQ~0_combout\ = (\Chip2|Chip3|present_state\(1) & ((\Chip2|Chip3|present_state\(0) $ (\Chip2|Chip1|present_state\(0))) # (!\Chip2|Chip1|present_state\(1)))) # (!\Chip2|Chip3|present_state\(1) & ((\Chip2|Chip1|present_state\(1)) # 
-- (\Chip2|Chip3|present_state\(0) $ (\Chip2|Chip1|present_state\(0)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0110111111110110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip3|present_state\(1),
	datab => \Chip2|Chip1|present_state\(1),
	datac => \Chip2|Chip3|present_state\(0),
	datad => \Chip2|Chip1|present_state\(0),
	combout => \Chip2|Chip2|Chip9|EQ~0_combout\);

-- Location: IOIBUF_X54_Y54_N22
\WP[3]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(3),
	o => \WP[3]~input_o\);

-- Location: FF_X56_Y52_N27
\Chip2|Chip3|present_state[3]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \WP[3]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(3));

-- Location: IOIBUF_X56_Y54_N1
\WP[2]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(2),
	o => \WP[2]~input_o\);

-- Location: FF_X56_Y52_N29
\Chip2|Chip3|present_state[2]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \WP[2]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(2));

-- Location: LCCOMB_X56_Y52_N28
\Chip2|Chip2|Chip9|EQ~4\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip2|Chip9|EQ~4_combout\ = (\Chip2|Chip3|present_state\(3) & ((\Chip2|Chip1|present_state\(2) $ (\Chip2|Chip3|present_state\(2))) # (!\Chip2|Chip1|present_state\(3)))) # (!\Chip2|Chip3|present_state\(3) & ((\Chip2|Chip1|present_state\(3)) # 
-- (\Chip2|Chip1|present_state\(2) $ (\Chip2|Chip3|present_state\(2)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0111110110111110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip3|present_state\(3),
	datab => \Chip2|Chip1|present_state\(2),
	datac => \Chip2|Chip3|present_state\(2),
	datad => \Chip2|Chip1|present_state\(3),
	combout => \Chip2|Chip2|Chip9|EQ~4_combout\);

-- Location: IOIBUF_X56_Y54_N8
\WP[5]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(5),
	o => \WP[5]~input_o\);

-- Location: LCCOMB_X56_Y52_N6
\Chip2|Chip3|present_state[5]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip3|present_state[5]~feeder_combout\ = \WP[5]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \WP[5]~input_o\,
	combout => \Chip2|Chip3|present_state[5]~feeder_combout\);

-- Location: FF_X56_Y52_N7
\Chip2|Chip3|present_state[5]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip3|present_state[5]~feeder_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(5));

-- Location: IOIBUF_X54_Y54_N29
\WP[4]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(4),
	o => \WP[4]~input_o\);

-- Location: FF_X56_Y52_N5
\Chip2|Chip3|present_state[4]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \WP[4]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(4));

-- Location: LCCOMB_X56_Y52_N4
\Chip2|Chip2|Chip9|EQ~3\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip2|Chip9|EQ~3_combout\ = (\Chip2|Chip3|present_state\(5) & ((\Chip2|Chip3|present_state\(4) $ (\Chip2|Chip1|present_state\(4))) # (!\Chip2|Chip1|present_state\(5)))) # (!\Chip2|Chip3|present_state\(5) & ((\Chip2|Chip1|present_state\(5)) # 
-- (\Chip2|Chip3|present_state\(4) $ (\Chip2|Chip1|present_state\(4)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0110111111110110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip3|present_state\(5),
	datab => \Chip2|Chip1|present_state\(5),
	datac => \Chip2|Chip3|present_state\(4),
	datad => \Chip2|Chip1|present_state\(4),
	combout => \Chip2|Chip2|Chip9|EQ~3_combout\);

-- Location: IOIBUF_X56_Y54_N29
\WP[8]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(8),
	o => \WP[8]~input_o\);

-- Location: FF_X56_Y52_N31
\Chip2|Chip3|present_state[8]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \WP[8]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(8));

-- Location: LCCOMB_X56_Y52_N30
\Chip2|Chip2|Chip8|EQ~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip2|Chip8|EQ~0_combout\ = \Chip2|Chip3|present_state\(8) $ (\Chip2|Chip1|present_state\(8))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111111110000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip2|Chip3|present_state\(8),
	datad => \Chip2|Chip1|present_state\(8),
	combout => \Chip2|Chip2|Chip8|EQ~0_combout\);

-- Location: IOIBUF_X51_Y54_N22
\WP[9]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(9),
	o => \WP[9]~input_o\);

-- Location: FF_X56_Y52_N17
\Chip2|Chip3|present_state[9]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \WP[9]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(9));

-- Location: IOIBUF_X56_Y54_N22
\WP[7]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(7),
	o => \WP[7]~input_o\);

-- Location: LCCOMB_X56_Y52_N20
\Chip2|Chip3|present_state[7]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip3|present_state[7]~feeder_combout\ = \WP[7]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \WP[7]~input_o\,
	combout => \Chip2|Chip3|present_state[7]~feeder_combout\);

-- Location: FF_X56_Y52_N21
\Chip2|Chip3|present_state[7]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip3|present_state[7]~feeder_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(7));

-- Location: IOIBUF_X56_Y54_N15
\WP[6]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_WP(6),
	o => \WP[6]~input_o\);

-- Location: FF_X56_Y52_N11
\Chip2|Chip3|present_state[6]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \WP[6]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip3|present_state\(6));

-- Location: LCCOMB_X56_Y52_N10
\Chip2|Chip2|Chip9|EQ~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip2|Chip9|EQ~1_combout\ = (\Chip2|Chip1|present_state\(7) & ((\Chip2|Chip3|present_state\(6) $ (\Chip2|Chip1|present_state\(6))) # (!\Chip2|Chip3|present_state\(7)))) # (!\Chip2|Chip1|present_state\(7) & ((\Chip2|Chip3|present_state\(7)) # 
-- (\Chip2|Chip3|present_state\(6) $ (\Chip2|Chip1|present_state\(6)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0110111111110110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(7),
	datab => \Chip2|Chip3|present_state\(7),
	datac => \Chip2|Chip3|present_state\(6),
	datad => \Chip2|Chip1|present_state\(6),
	combout => \Chip2|Chip2|Chip9|EQ~1_combout\);

-- Location: LCCOMB_X56_Y52_N16
\Chip2|Chip2|Chip9|EQ~2\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip2|Chip9|EQ~2_combout\ = (\Chip2|Chip2|Chip8|EQ~0_combout\) # ((\Chip2|Chip2|Chip9|EQ~1_combout\) # (\Chip2|Chip1|present_state\(9) $ (\Chip2|Chip3|present_state\(9))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111110111110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip2|Chip8|EQ~0_combout\,
	datab => \Chip2|Chip1|present_state\(9),
	datac => \Chip2|Chip3|present_state\(9),
	datad => \Chip2|Chip2|Chip9|EQ~1_combout\,
	combout => \Chip2|Chip2|Chip9|EQ~2_combout\);

-- Location: LCCOMB_X56_Y52_N18
\Chip2|Chip2|Chip9|EQ~5\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip2|Chip9|EQ~5_combout\ = (\Chip2|Chip2|Chip9|EQ~0_combout\) # ((\Chip2|Chip2|Chip9|EQ~4_combout\) # ((\Chip2|Chip2|Chip9|EQ~3_combout\) # (\Chip2|Chip2|Chip9|EQ~2_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111111111110",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip2|Chip9|EQ~0_combout\,
	datab => \Chip2|Chip2|Chip9|EQ~4_combout\,
	datac => \Chip2|Chip2|Chip9|EQ~3_combout\,
	datad => \Chip2|Chip2|Chip9|EQ~2_combout\,
	combout => \Chip2|Chip2|Chip9|EQ~5_combout\);

-- Location: LCCOMB_X56_Y52_N24
\Chip1|current_state.state_bit_1~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_1~0_combout\ = (\Chip1|current_state.state_bit_1~q\ & (!\ST~input_o\ & ((\Chip2|Chip2|Chip9|EQ~5_combout\) # (!\Chip1|current_state.state_bit_0~q\)))) # (!\Chip1|current_state.state_bit_1~q\ & 
-- (((\Chip1|current_state.state_bit_0~q\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0101110000011100",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \ST~input_o\,
	datab => \Chip1|current_state.state_bit_0~q\,
	datac => \Chip1|current_state.state_bit_1~q\,
	datad => \Chip2|Chip2|Chip9|EQ~5_combout\,
	combout => \Chip1|current_state.state_bit_1~0_combout\);

-- Location: FF_X56_Y52_N25
\Chip1|current_state.state_bit_1\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip1|current_state.state_bit_1~0_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|current_state.state_bit_1~q\);

-- Location: IOIBUF_X58_Y54_N15
\PW[1]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(1),
	o => \PW[1]~input_o\);

-- Location: FF_X57_Y52_N15
\Chip2|Chip5|present_state[1]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \PW[1]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(1));

-- Location: IOIBUF_X60_Y54_N22
\PW[0]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(0),
	o => \PW[0]~input_o\);

-- Location: LCCOMB_X57_Y52_N0
\Chip2|Chip5|present_state[0]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip5|present_state[0]~feeder_combout\ = \PW[0]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \PW[0]~input_o\,
	combout => \Chip2|Chip5|present_state[0]~feeder_combout\);

-- Location: FF_X57_Y52_N1
\Chip2|Chip5|present_state[0]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip5|present_state[0]~feeder_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(0));

-- Location: LCCOMB_X57_Y52_N14
\Chip1|current_state.state_bit_0~5\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_0~5_combout\ = (\Chip2|Chip1|present_state\(0) & (\Chip2|Chip5|present_state\(0) & (\Chip2|Chip1|present_state\(1) $ (!\Chip2|Chip5|present_state\(1))))) # (!\Chip2|Chip1|present_state\(0) & (!\Chip2|Chip5|present_state\(0) 
-- & (\Chip2|Chip1|present_state\(1) $ (!\Chip2|Chip5|present_state\(1)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1000001001000001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(0),
	datab => \Chip2|Chip1|present_state\(1),
	datac => \Chip2|Chip5|present_state\(1),
	datad => \Chip2|Chip5|present_state\(0),
	combout => \Chip1|current_state.state_bit_0~5_combout\);

-- Location: IOIBUF_X54_Y54_N15
\PW[6]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(6),
	o => \PW[6]~input_o\);

-- Location: FF_X57_Y52_N19
\Chip2|Chip5|present_state[6]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \PW[6]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(6));

-- Location: IOIBUF_X58_Y54_N22
\PW[7]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(7),
	o => \PW[7]~input_o\);

-- Location: FF_X57_Y52_N13
\Chip2|Chip5|present_state[7]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \PW[7]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(7));

-- Location: LCCOMB_X57_Y52_N12
\Chip1|current_state.state_bit_0~1\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_0~1_combout\ = (\Chip2|Chip1|present_state\(7) & (\Chip2|Chip5|present_state\(7) & (\Chip2|Chip5|present_state\(6) $ (!\Chip2|Chip1|present_state\(6))))) # (!\Chip2|Chip1|present_state\(7) & (!\Chip2|Chip5|present_state\(7) 
-- & (\Chip2|Chip5|present_state\(6) $ (!\Chip2|Chip1|present_state\(6)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1000010000100001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip1|present_state\(7),
	datab => \Chip2|Chip5|present_state\(6),
	datac => \Chip2|Chip5|present_state\(7),
	datad => \Chip2|Chip1|present_state\(6),
	combout => \Chip1|current_state.state_bit_0~1_combout\);

-- Location: IOIBUF_X58_Y54_N8
\PW[8]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(8),
	o => \PW[8]~input_o\);

-- Location: FF_X57_Y52_N27
\Chip2|Chip5|present_state[8]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \PW[8]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(8));

-- Location: IOIBUF_X58_Y54_N1
\PW[9]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(9),
	o => \PW[9]~input_o\);

-- Location: FF_X57_Y52_N17
\Chip2|Chip5|present_state[9]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \PW[9]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(9));

-- Location: LCCOMB_X57_Y52_N16
\Chip1|current_state.state_bit_0~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_0~0_combout\ = (\Chip2|Chip5|present_state\(8) & (\Chip2|Chip1|present_state\(8) & (\Chip2|Chip5|present_state\(9) $ (!\Chip2|Chip1|present_state\(9))))) # (!\Chip2|Chip5|present_state\(8) & (!\Chip2|Chip1|present_state\(8) 
-- & (\Chip2|Chip5|present_state\(9) $ (!\Chip2|Chip1|present_state\(9)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1001000000001001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip5|present_state\(8),
	datab => \Chip2|Chip1|present_state\(8),
	datac => \Chip2|Chip5|present_state\(9),
	datad => \Chip2|Chip1|present_state\(9),
	combout => \Chip1|current_state.state_bit_0~0_combout\);

-- Location: IOIBUF_X60_Y54_N15
\PW[4]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(4),
	o => \PW[4]~input_o\);

-- Location: LCCOMB_X57_Y52_N6
\Chip2|Chip5|present_state[4]~feeder\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip2|Chip5|present_state[4]~feeder_combout\ = \PW[4]~input_o\

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datad => \PW[4]~input_o\,
	combout => \Chip2|Chip5|present_state[4]~feeder_combout\);

-- Location: FF_X57_Y52_N7
\Chip2|Chip5|present_state[4]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip2|Chip5|present_state[4]~feeder_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(4));

-- Location: IOIBUF_X60_Y54_N29
\PW[5]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(5),
	o => \PW[5]~input_o\);

-- Location: FF_X57_Y52_N9
\Chip2|Chip5|present_state[5]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \PW[5]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(5));

-- Location: LCCOMB_X57_Y52_N8
\Chip1|current_state.state_bit_0~2\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_0~2_combout\ = (\Chip2|Chip5|present_state\(4) & (\Chip2|Chip1|present_state\(4) & (\Chip2|Chip5|present_state\(5) $ (!\Chip2|Chip1|present_state\(5))))) # (!\Chip2|Chip5|present_state\(4) & (!\Chip2|Chip1|present_state\(4) 
-- & (\Chip2|Chip5|present_state\(5) $ (!\Chip2|Chip1|present_state\(5)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1001000000001001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip5|present_state\(4),
	datab => \Chip2|Chip1|present_state\(4),
	datac => \Chip2|Chip5|present_state\(5),
	datad => \Chip2|Chip1|present_state\(5),
	combout => \Chip1|current_state.state_bit_0~2_combout\);

-- Location: IOIBUF_X60_Y54_N1
\PW[2]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(2),
	o => \PW[2]~input_o\);

-- Location: FF_X57_Y52_N31
\Chip2|Chip5|present_state[2]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \PW[2]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(2));

-- Location: IOIBUF_X60_Y54_N8
\PW[3]~input\ : fiftyfivenm_io_ibuf
-- pragma translate_off
GENERIC MAP (
	bus_hold => "false",
	listen_to_nsleep_signal => "false",
	simulate_z_as => "z")
-- pragma translate_on
PORT MAP (
	i => ww_PW(3),
	o => \PW[3]~input_o\);

-- Location: FF_X57_Y52_N29
\Chip2|Chip5|present_state[3]\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	asdata => \PW[3]~input_o\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	sload => VCC,
	ena => \Chip1|current_state.Load_regs~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip2|Chip5|present_state\(3));

-- Location: LCCOMB_X57_Y52_N28
\Chip1|current_state.state_bit_0~3\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_0~3_combout\ = (\Chip2|Chip5|present_state\(2) & (\Chip2|Chip1|present_state\(2) & (\Chip2|Chip1|present_state\(3) $ (!\Chip2|Chip5|present_state\(3))))) # (!\Chip2|Chip5|present_state\(2) & (!\Chip2|Chip1|present_state\(2) 
-- & (\Chip2|Chip1|present_state\(3) $ (!\Chip2|Chip5|present_state\(3)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1000001001000001",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip2|Chip5|present_state\(2),
	datab => \Chip2|Chip1|present_state\(3),
	datac => \Chip2|Chip5|present_state\(3),
	datad => \Chip2|Chip1|present_state\(2),
	combout => \Chip1|current_state.state_bit_0~3_combout\);

-- Location: LCCOMB_X57_Y52_N20
\Chip1|current_state.state_bit_0~4\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_0~4_combout\ = (\Chip1|current_state.state_bit_0~1_combout\ & (\Chip1|current_state.state_bit_0~0_combout\ & (\Chip1|current_state.state_bit_0~2_combout\ & \Chip1|current_state.state_bit_0~3_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1000000000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|current_state.state_bit_0~1_combout\,
	datab => \Chip1|current_state.state_bit_0~0_combout\,
	datac => \Chip1|current_state.state_bit_0~2_combout\,
	datad => \Chip1|current_state.state_bit_0~3_combout\,
	combout => \Chip1|current_state.state_bit_0~4_combout\);

-- Location: LCCOMB_X57_Y52_N22
\Chip1|current_state.state_bit_0~6\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_0~6_combout\ = (\Chip1|current_state.Wave_ON~0_combout\ & (!\ST~input_o\ & (\Chip1|current_state.state_bit_0~5_combout\ & \Chip1|current_state.state_bit_0~4_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0010000000000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \Chip1|current_state.Wave_ON~0_combout\,
	datab => \ST~input_o\,
	datac => \Chip1|current_state.state_bit_0~5_combout\,
	datad => \Chip1|current_state.state_bit_0~4_combout\,
	combout => \Chip1|current_state.state_bit_0~6_combout\);

-- Location: LCCOMB_X56_Y52_N14
\Chip1|current_state.state_bit_0~7\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.state_bit_0~7_combout\ = (\Chip1|current_state.state_bit_0~6_combout\) # ((\ST~input_o\ & (!\Chip1|current_state.state_bit_1~q\ & !\Chip1|current_state.state_bit_0~q\)) # (!\ST~input_o\ & (\Chip1|current_state.state_bit_1~q\ & 
-- \Chip1|current_state.state_bit_0~q\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "1111111101000010",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	dataa => \ST~input_o\,
	datab => \Chip1|current_state.state_bit_1~q\,
	datac => \Chip1|current_state.state_bit_0~q\,
	datad => \Chip1|current_state.state_bit_0~6_combout\,
	combout => \Chip1|current_state.state_bit_0~7_combout\);

-- Location: FF_X56_Y52_N15
\Chip1|current_state.state_bit_0\ : dffeas
-- pragma translate_off
GENERIC MAP (
	is_wysiwyg => "true",
	power_up => "low")
-- pragma translate_on
PORT MAP (
	clk => \CLK~inputclkctrl_outclk\,
	d => \Chip1|current_state.state_bit_0~7_combout\,
	clrn => \ALT_INV_CD~inputclkctrl_outclk\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	q => \Chip1|current_state.state_bit_0~q\);

-- Location: LCCOMB_X56_Y52_N8
\Chip1|current_state.Wave_ON~0\ : fiftyfivenm_lcell_comb
-- Equation(s):
-- \Chip1|current_state.Wave_ON~0_combout\ = (!\Chip1|current_state.state_bit_0~q\ & \Chip1|current_state.state_bit_1~q\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000111100000000",
	sum_lutc_input => "datac")
-- pragma translate_on
PORT MAP (
	datac => \Chip1|current_state.state_bit_0~q\,
	datad => \Chip1|current_state.state_bit_1~q\,
	combout => \Chip1|current_state.Wave_ON~0_combout\);

-- Location: UNVM_X0_Y40_N40
\~QUARTUS_CREATED_UNVM~\ : fiftyfivenm_unvm
-- pragma translate_off
GENERIC MAP (
	addr_range1_end_addr => -1,
	addr_range1_offset => -1,
	addr_range2_end_addr => -1,
	addr_range2_offset => -1,
	addr_range3_offset => -1,
	is_compressed_image => "false",
	is_dual_boot => "false",
	is_eram_skip => "false",
	max_ufm_valid_addr => -1,
	max_valid_addr => -1,
	min_ufm_valid_addr => -1,
	min_valid_addr => -1,
	part_name => "quartus_created_unvm",
	reserve_block => "true")
-- pragma translate_on
PORT MAP (
	nosc_ena => \~QUARTUS_CREATED_GND~I_combout\,
	xe_ye => \~QUARTUS_CREATED_GND~I_combout\,
	se => \~QUARTUS_CREATED_GND~I_combout\,
	busy => \~QUARTUS_CREATED_UNVM~~busy\);

-- Location: ADCBLOCK_X43_Y52_N0
\~QUARTUS_CREATED_ADC1~\ : fiftyfivenm_adcblock
-- pragma translate_off
GENERIC MAP (
	analog_input_pin_mask => 0,
	clkdiv => 1,
	device_partname_fivechar_prefix => "none",
	is_this_first_or_second_adc => 1,
	prescalar => 0,
	pwd => 1,
	refsel => 0,
	reserve_block => "true",
	testbits => 66,
	tsclkdiv => 1,
	tsclksel => 0)
-- pragma translate_on
PORT MAP (
	soc => \~QUARTUS_CREATED_GND~I_combout\,
	usr_pwd => VCC,
	tsen => \~QUARTUS_CREATED_GND~I_combout\,
	chsel => \~QUARTUS_CREATED_ADC1~_CHSEL_bus\,
	eoc => \~QUARTUS_CREATED_ADC1~~eoc\);

-- Location: ADCBLOCK_X43_Y51_N0
\~QUARTUS_CREATED_ADC2~\ : fiftyfivenm_adcblock
-- pragma translate_off
GENERIC MAP (
	analog_input_pin_mask => 0,
	clkdiv => 1,
	device_partname_fivechar_prefix => "none",
	is_this_first_or_second_adc => 2,
	prescalar => 0,
	pwd => 1,
	refsel => 0,
	reserve_block => "true",
	testbits => 66,
	tsclkdiv => 1,
	tsclksel => 0)
-- pragma translate_on
PORT MAP (
	soc => \~QUARTUS_CREATED_GND~I_combout\,
	usr_pwd => VCC,
	tsen => \~QUARTUS_CREATED_GND~I_combout\,
	chsel => \~QUARTUS_CREATED_ADC2~_CHSEL_bus\,
	eoc => \~QUARTUS_CREATED_ADC2~~eoc\);

ww_PWM_out <= \PWM_out~output_o\;

ww_PWM_out_L <= \PWM_out_L~output_o\;
END structure;


