-- Copyright (C) 2020  Intel Corporation. All rights reserved.
-- Your use of Intel Corporation's design tools, logic functions 
-- and other software and tools, and any partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Intel Program License 
-- Subscription Agreement, the Intel Quartus Prime License Agreement,
-- the Intel FPGA IP License Agreement, or other applicable license
-- agreement, including, without limitation, that your use is for
-- the sole purpose of programming logic devices manufactured by
-- Intel and sold by Intel or its authorized distributors.  Please
-- refer to the applicable agreement for further details, at
-- https://fpgasoftware.intel.com/eula.

-- ***************************************************************************
-- This file contains a Vhdl test bench template that is freely editable to   
-- suit user's needs .Comments are provided in each section to help the user  
-- fill out necessary details.                                                
-- ***************************************************************************
-- Generated on "01/12/2026 13:10:23"
                                                            
-- Vhdl Test Bench template for design  :  PWM
-- 
-- Simulation tool : ModelSim-Altera (VHDL)
-- 

LIBRARY ieee;                                               
USE ieee.std_logic_1164.all;                                

ENTITY PWM_vhd_tst IS
END PWM_vhd_tst;
ARCHITECTURE PWM_arch OF PWM_vhd_tst IS
-- constants                                                 
-- ---------------------------------------------------------------------------
	-- Clock period definitions
	-- FCLK = 1 MHz. We can simulate 10-bit resolution up to 1 kHz signals
	constant CLK_period : time := 1 us; 

-- signals                                                   
SIGNAL CD : STD_LOGIC;
SIGNAL CLK : STD_LOGIC;
SIGNAL PW : STD_LOGIC_VECTOR(9 DOWNTO 0);
SIGNAL PWM_out : STD_LOGIC;
SIGNAL PWM_out_L : STD_LOGIC;
SIGNAL ST : STD_LOGIC;
SIGNAL WP : STD_LOGIC_VECTOR(9 DOWNTO 0);

COMPONENT PWM
	PORT (
	CD : IN STD_LOGIC;
	CLK : IN STD_LOGIC;
	PW : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
	PWM_out : OUT STD_LOGIC;
	PWM_out_L : OUT STD_LOGIC;
	ST : IN STD_LOGIC;
	WP : IN STD_LOGIC_VECTOR(9 DOWNTO 0)
	);
END COMPONENT;

BEGIN
	i1 : PWM
	PORT MAP (
-- list connections between master ports and signals
	CD => CD,
	CLK => CLK,
	PW => PW,
	PWM_out => PWM_out,
	PWM_out_L => PWM_out_L,
	ST => ST,
	WP => WP
	);
	



-- *** Test Bench - User Defined Section ***
	-- Clock process definitions
	CLK_signal :process
	begin
		CLK <= '0';
		wait for CLK_period/2;
		CLK <= '1';
		wait for CLK_period/2;
	end process;

	-- Stimulus process
	stim_proc: process
	begin		
	--  A kind of power supply turn on
	wait for 100 ns;	
	wait for CLK_period*2.3;

	-- Clear direct 
	CD 		<= '1';
	wait for CLK_period*4.56;

	CD 		<= '0';
	wait for CLK_period*8.75;
--------------------------------------------------------------------------------
-- Let us fix a frequency of 1 kHz and a DC = 50%
				-- T_PWM_out = (WP +2)·TCLK			T_ON = (PW +1)
	WP <= "1111100110"; -- This is 998 
	PW <= "0111110011"; -- Value 499   DC = (499+1)/(998 + 2) = 50%
	ST <= '0';
	wait for CLK_period*2.56;
	
	-- Let us simulate a start click 
	
	ST <= '1';
	wait for CLK_period*1.19;
	
	ST <= '0';
	wait for CLK_period*4356.86; -- It will have time to run several waveform periods

	-- Let us simulate a stop click 
	
	ST <= '1';
	wait for CLK_period*1.1;
	
	ST <= '0';
	wait for CLK_period*1222.33; -- Device stopped (Idle)

-- Another DC = 25%
	PW <= "0011111001"; -- 249  	DC = (250/1000) = 0.25

	-- Let us simulate a start click 
	
	ST <= '1';
	wait for CLK_period*1.1;
	
	ST <= '0';
	wait for CLK_period*2400; -- It will have time to run several waveform periods

	
	ST <= '1';
	wait for CLK_period*1.1; -- stop pulse to go Idle 
	
	ST <= '0';
	wait for CLK_period*560.8;


-- Another Frequency WP = 13 (FCLK = 66.666 kHz, another DC = 20%
	PW <= "0000000010"; -- 2		DC = (2 + 1)/(13+2) = 0.20
	WP <= "0000001101"; -- This is 13 (the waveform will be of a period = 15 TCLK
	-- Let us simulate a start click 
	
	ST <= '1';
	wait for CLK_period*1.1;
	
	ST <= '0';
	wait for CLK_period*78.8; -- It will have time to run several waveform periods

	
	ST <= '1';
	wait for CLK_period*1.1;-- Idle
	
	ST <= '0';
	wait for CLK_period*44.8; 



-- DC = 1/15 = 6.6%
	PW <= "0000000000"; -- DC = (0 + 1)/(13+2) = 6.66%
	-- Let us simulate a start click 
	
	ST <= '1';
	wait for CLK_period*1.1; -- run
	
	ST <= '0';
	wait for CLK_period*78.8; -- It will have time to run several waveform periods

	
	ST <= '1';
	wait for CLK_period*1.1;-- Idle
	
	ST <= '0';
	wait for CLK_period*80.8; 



--------------------------------------------------------------------------------
			-- Max count for both, WP and PW  (frequency = 975.61 Hz)
	WP <= "1111111111"; -- This is 1023 (the waveform will be Period = 1025·TCLK
	PW <= "1111111110"; -- Value 1022  DC = (1022+1)/(1023 + 2) = 99.8%
	wait for CLK_period*12.56;
	
	-- Let us simulate a start click 
	
	ST <= '1';
	wait for CLK_period*1.1;
	
	ST <= '0';
	wait for CLK_period*4356.86; -- It will have time to run several waveform periods

	-- Let us simulate a stop click 
	
	ST <= '1';
	wait for CLK_period*1.1;
	
	ST <= '0';
	wait for CLK_period*1222.33; -- Device stopped (Idle)




--------------------------------------------------------------------------------
			-- Min count for PW  (frequency = 975.61 Hz)
	WP <= "1111111111"; -- This is 1023 (the waveform will be Period = 1025·TCLK
	PW <= "0000000000"; -- Value 0   DC = (0+1)/(1023 + 2) = 0.097%
	ST <= '0';
	wait for CLK_period*2.56;
	
	-- Let us simulate a start click 
	
	ST <= '1';
	wait for CLK_period*1.1;
	
	ST <= '0';
	wait for CLK_period*4356.86; -- It will have time to run several waveform periods

	-- Let us simulate a stop click 
	
	ST <= '1';
	wait for CLK_period*1.1;
	
	ST <= '0';
	wait for CLK_period*1222.33; -- Device stopped (Idle)




	wait;

	-- end of user generated stimulus
  
   end process;
  
-- *** End Test Bench - User Defined Section ***




END PWM_arch;
