--------------------------------------------------------------------------------
-- An example of a 1-bit comparator using described using simplified logic 
-- equations (structural) Sum of Products (SoP)
---------------------------------------------------
-- Project P4  - CSD :  Arithmetic circuits
-- http://digsys.upc.edu
--------------------------------------------------------------------------------
LIBRARY ieee;
USE  IEEE.STD_LOGIC_1164.all;

ENTITY Comp_1bit IS
		PORT (
			A,B, Gi, Ei, Li	: IN STD_LOGIC;				
			GT, EQ, LT		: OUT STD_LOGIC
		  );
END Comp_1bit;

ARCHITECTURE logic_equations_SoP OF Comp_1bit IS
BEGIN

GT <= (not(B) and Gi) or (A and Gi) or (A and not(B));
LT <= (not(A) and Li) or (B and Li) or (B and not(A));
EQ <= (not(A) and not(B) and Ei) or (A and B and Ei);

		 		   	 		 		   	   
END logic_equations_SoP;
