
--------------------------------------------------------------------------------
-- Example arithmetic circuit 
-- 10-bit comparator for radix 2 numbers (unsigned)
-- Structural approach (Plan C2) and cascadable. 
-- UPC - EETAC - CSD 
-- https://digsys.upc.edu/csd/P03/Comp_10bit/Comp_10bit.html
-- Theory, ideas and similar circuits in P3
-- This VHDL translation corresponds with the schematic in Fig.3 attribute
-- https://digsys.upc.edu/csd/P03/Comp_10bit/img_planC2.jpg
--------------------------------------------------------------------------------
LIBRARY ieee;
USE  IEEE.STD_LOGIC_1164.all;

ENTITY Comp_10bit IS
	PORT (
		A, B		: IN	STD_LOGIC_VECTOR(9 DOWNTO 0);
		Gi, Ei, Li	: IN	STD_LOGIC;
		GT, EQ, LT	: OUT	STD_LOGIC
	);  
END Comp_10bit;

ARCHITECTURE hierarchical_structure OF Comp_10bit IS

-- Components to be used:
	COMPONENT Comp_1bit IS     -- From P3 tutorial
		PORT (
			A,B, Gi, Ei, Li	: IN STD_LOGIC;	
			GT, EQ, LT		: OUT STD_LOGIC
		  );
		END COMPONENT;

-- Signals, -- The wires to connect the modules:
	SIGNAL	C, D, E, F, G, H, I, J, K: STD_LOGIC_VECTOR (2 DOWNTO 0);

BEGIN

-- Instantiating all the Comp_1bit

	Chip0	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(0),
			B		=> B(0),
			Gi		=> Gi,
			Ei		=> Ei,
			Li		=> Li,
			GT		=> C(2),
			EQ		=> C(1),
			LT		=> C(0)
		);

	Chip1	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(1),
			B		=> B(1),
			Gi		=> C(2),
			Ei		=> C(1),
			Li		=> C(0),
			GT		=> D(2),
			EQ		=> D(1),
			LT		=> D(0)
		);
		
	Chip2	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(2),
			B		=> B(2),
			Gi		=> D(2),
			Ei		=> D(1),
			Li		=> D(0),
			GT		=> E(2),
			EQ		=> E(1),
			LT		=> E(0)
		);

	Chip3	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(3),
			B		=> B(3),
			Gi		=> E(2),
			Ei		=> E(1),
			Li		=> E(0),
			GT		=> F(2),
			EQ		=> F(1),
			LT		=> F(0)
		);

	Chip4	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(4),
			B		=> B(4),
			Gi		=> F(2),
			Ei		=> F(1),
			Li		=> F(0),
			GT		=> G(2),
			EQ		=> G(1),
			LT		=> G(0)
		);

	Chip5	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(5),
			B		=> B(5),
			Gi		=> G(2),
			Ei		=> G(1),
			Li		=> G(0),
			GT		=> H(2),
			EQ		=> H(1),
			LT		=> H(0)
		);	

	Chip6	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(6),
			B		=> B(6),
			Gi		=> H(2),
			Ei		=> H(1),
			Li		=> H(0),
			GT		=> I(2),
			EQ		=> I(1),
			LT		=> I(0)
		);	

	Chip7	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(7),
			B		=> B(7),
			Gi		=> I(2),
			Ei		=> I(1),
			Li		=> I(0),
			GT		=> J(2),
			EQ		=> J(1),
			LT		=> J(0)
		);

	Chip8	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(8),
			B		=> B(8),
			Gi		=> J(2),
			Ei		=> J(1),
			Li		=> J(0),
			GT		=> K(2),
			EQ		=> K(1),
			LT		=> K(0)
		);


	Chip9	: Comp_1bit
		PORT MAP (
	-- from component name 	=> to signal or port name
			A		=> A(9),
			B		=> B(9),
			Gi		=> K(2),
			Ei		=> K(1),
			Li		=> K(0),
			GT		=> GT,
			EQ		=> EQ,
			LT		=> LT
		);	
		
-- Other circuits and equations: not necessary 

END hierarchical_structure;

		
