/*	===========================================================================
 UPC - EETAC - CSD - http://digsys.upc.edu 

 * PROJECTE MAGNET (https://magnet.cat/). 
 * Escola La Guàrdia, Sant Vicenç dels Horts, Baix Llobregat
 
 Documentació: https://digsys.upc.edu/csd/P12/MAGNET/Aixeta/Control_Aixeta.html
 Arduino Uno. Xip ATmega328P
===========================================================================
 L'automatisme provoca l'accionament de la bobina de 5 V del relé. 
 L'electrovàlvula de solenoide o qualsevol altra aplicació elèctrica 
 (làmpada, motor, etc.) ha de connectar-se a l'interruptor del relé. 
 Mentre raja aigua hi ha un LED intermitent

Planificació del projecte: 

- Pas 1: Trobarem un programa per comprovar com funciona el sensor d'ultrasons.
I així ja veurem quina biblioteca de funcions d'Arduino relacionada amb aquest 
sensor haurem d'instal·lar i com s'haurà utilitzar. 
A la pàgina Arduino.cc en trobareu unes quantes. 


- Pas 2: Programarem el circuit. Hi ha un parell de tècniques:
(1) Programa descrit amb diagrama de flux d'operacions a realitzar.
Aquest programa és la traducció del diagrama de flux de la Fig. 4 (1):
https://digsys.upc.edu/csd/P12/MAGNET/Aixeta/img_diagrames.jpg


(2)(alternativa avançada). Programa de màquina d'estats finits. 
    - El temps es mesurarà amb la funció millis() 

=============================================================================*/

/*	===========================================================================
	Secció #include de funcions externes
	=========================================================================*/
#include <DistanceSensor.h>

/*	===========================================================================
	Constants
	=========================================================================*/
// Disposició de pins de l'Arduino
const byte Eco_pin = 4; 
const byte Gallet_pin = 3;

const byte Pilot_LED_pin = 7; 
const byte Aixeta_pin = 8;

// Període de temps per generar la intermitència de mig segon
const unsigned long PERIODE_TEMPS = 500;  // mil·lisegons

const int LLINDAR_DETECCIO = 40; // 40 cm

// Com que el temps s'estableix comprant períodes PERIODE_TEMPS, aquest valor
// proposat representarà 10 segons de funcionament
const byte TEMPORITZACIO_AIXETA = 10;  //amb aquesta variable 'byte' maxim 255)

/*	===========================================================================
	Variables
	======================================================================== */
int  var_Dist;  // Distància ue separa el sensor i l'obstacle


// Configuració del sensor d'ultrasons
DistanceSensor sensor(Gallet_pin, Eco_pin);

/*	===========================================================================
	Funció d'inicialització
	=========================================================================*/
void setup () {
// Inicialitzem el monitor del port serie per transmetre les distàncies
    Serial.begin(9600);
// Enviem el primer missatge
	Serial.println("Project MAGNET - Aixeta d'aigua");

// Configurem un parell de sortides 
	pinMode(Aixeta_pin, OUTPUT);  
	pinMode(Pilot_LED_pin, OUTPUT);	
// L'altra sortida (gallet) l'entrada (eco) les configura la funció del sensor

// Iniciem les sortides amb l'aixeta tancada
    digitalWrite(Aixeta_pin, LOW);   // Aixeta = 0;
    digitalWrite(Pilot_LED_pin, LOW);   // Pilot = 0;

    var_Dist = 200;
      //Temporitza una mica abans de començar. 
  delay (1000);  
}

/*	===========================================================================
	Funció de llaç infinit
	=========================================================================*/
void loop () {
byte i;

// Llegeix distància en cm
    var_Dist = sensor.getCM();

// Envia la distància calculada al monitor sèrie
    Serial.print("Distància: "); Serial.print(var_Dist); Serial.println("cm");

// Comparador
  if (var_Dist < LLINDAR_DETECCIO){   // Activació de l'aixeta
    digitalWrite(Aixeta_pin, HIGH);   // Aixeta = 1;
									
    for (i = 0; i < TEMPORITZACIO_AIXETA; i++){			// Pilot intermitent
      digitalWrite(Pilot_LED_pin, HIGH);   // Pilot = 1;
      delay (500);                  
      digitalWrite(Pilot_LED_pin, LOW);   // Pilot = 0;
      delay (500);      
    }

  }
  digitalWrite(Pilot_LED_pin, LOW);   // Pilot = 0;
  digitalWrite(Aixeta_pin, LOW);   // Aixeta = 0;

  //Temporitza una mica abans de tornar a començar. 
  delay (1000);  
}
